package com.yizhi.point.application.vo;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotations.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "PointParamVO", description = "其他微服务配置 积分")
public class
PointParamVO implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private String id;

	@ApiModelProperty(value = "事件名称")
	private String eventName;

	@ApiModelProperty(value = "事件类型/学习活动类型, 枚举 统一传入 ActivityTypeEnum.类型")
	private String activityType;

	@ApiModelProperty(value = "学习活动来源")
	private String activitySource;

	@ApiModelProperty(value = "积分来源Id, 存放业务主键， 课程Id，调研Id，考试Id, 投票ID, 作业ID")
	private Long sourceId;

	@ApiModelProperty(value = "课程id")
	private Long courseId;

	@ApiModelProperty(value = "如果是考试,发送考试成绩")
	private Integer score;

	@ApiModelProperty(value = "积分规则  1按课程  2 按章节 3 按素材")
	private Integer portRule;

	@ApiModelProperty(value = "学习活动名称")
	private String activityName;

	@ApiModelProperty(value = "发放条件")
	private String releaseCondition;

	@ApiModelProperty(value = "发放规则")
	private String releaseRules;

	@ApiModelProperty(value = "积分数量，  正数 加积分，  负数减积分")
	private Integer operatingPoint;

	@ApiModelProperty(value = "积分活动创建时间")
	private Date createPointTime;

	@ApiModelProperty(value = "学员id")
	private Long accountId;

	@ApiModelProperty(value = "学员姓名")
	private String accountName;

	private Long siteId;

	private Long orgId;

	private Long companyId;

}
