package com.yizhi.point.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 学员积分
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Data
@ApiModel(value = "PointUserVo", description = "用户积分")
@TableName("point_user")
public class PointUserVo extends Model<PointUserVo> {

    private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
    private Long id;

	@ApiModelProperty(value = "外键")
    @TableField("user_id")
    private Long userId;

	@ApiModelProperty(value = "总积分")
    @TableField("total_point")
    private Integer totalPoint;

	@ApiModelProperty(value = "未使用积分")
    @TableField("unused_point")
    private Integer unusedPoint;

	@ApiModelProperty(value = "状态 0 删除， 1 未删除")
    private Integer state;

	@ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

	@ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;

	@ApiModelProperty(value = "创建人姓名")
    @TableField("create_by_name")
    private String createByName;

	@ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;

	@ApiModelProperty(value = "修改人")
    @TableField("update_by_id")
    private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
    @TableField("update_by_name")
    private String updateByName;

	@ApiModelProperty(value = "公司ID")
    @TableField("company_id")
    private Long companyId;

	@ApiModelProperty(value = "部门ID")
    @TableField("org_id")
    private Long orgId;

	@ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
