package com.yizhi.point.application.feign;

import com.yizhi.point.application.vo.domain.PointVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 积分设置
 * 
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 */
@FeignClient(name = "point", contextId = "PointFeignClients")
public interface PointFeignClients {

	@GetMapping("/manage/point/strategy/view")
    PointVo pointList(@RequestParam("companyId") Long companyId, @RequestParam("siteId") Long siteId);

	@PostMapping("/manage/point/strategy/update")
	boolean updateList(@RequestBody PointVo point);

	@GetMapping("/manage/point/addPoint")
	boolean addPoint(
			@RequestParam(name = "accountId" ,required = false ) Long accountId,
			@RequestParam(name = "type" ,required = false ) String type,
			@RequestParam(name = "sourceId" ,required = false ) String sourceId);
}
