package com.yizhi.point.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 	mq消息
 * </p>
 *
 * @author bob123
 * @since 2018-05-08
 */
@Data
@ApiModel(value = "MqPointParamVo", description = "mq消息存储")
@TableName("mq_point_param")
public class MqPointParamVo extends Model<MqPointParamVo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "事件名称")
    @TableField("event_name")
    private String eventName;

    @ApiModelProperty(value = "事件类型/学习活动类型, 枚举 统一传入 ActivityTypeEnum.类型")
    @TableField("activity_type")
    private String activityType;

    @ApiModelProperty(value = "学习活动来源")
    @TableField("activity_source")
    private String activitySource;

    @ApiModelProperty(value = "积分来源Id, 存放业务主键， 课程Id，调研Id，考试Id, 投票ID, 作业ID")
    @TableField("source_id")
    private Long sourceId;

    @ApiModelProperty(value = "课程id")
    @TableField("course_id")
    private Long courseId;

    @ApiModelProperty(value = "学习活动名称")
    @TableField("activity_name")
    private String activityName;

    @ApiModelProperty(value = "发放条件")
    @TableField("release_condition")
    private String releaseCondition;

    @ApiModelProperty(value = "发放规则")
    @TableField("release_rules")
    private String releaseRules;

    @ApiModelProperty(value = "积分数量，  正数 加积分，  负数减积分")
    @TableField("operating_point")
    private Integer operatingPoint;

    @ApiModelProperty(value = "积分活动创建时间")
    @TableField("create_point_time")
    private Date createPointTime;

    @ApiModelProperty(value = "学员id")
    @TableField("account_id")
    private Long accountId;

    @ApiModelProperty(value = "学员姓名")
    @TableField("account_name")
    private String accountName;

    @TableField("site_id")
    private Long siteId;

    @TableField("org_id")
    private Long orgId;

    @TableField("company_id")
    private Long companyId;

    private Integer state;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
