package com.yizhi.point.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 积分设置
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Data
@ApiModel(value = "PointVo", description = "积分")
@TableName("point")
public class PointVo extends Model<PointVo> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "积分策略ID")
	private Long id;

	@ApiModelProperty(value = "积分单位")
	private String unit;

	@ApiModelProperty(value = "是否启用 0:未启用 1 启用")
	private Integer state;

	@ApiModelProperty(value = "创建时间")
	@TableField("create_time")
	private Date createTime;

	@ApiModelProperty(value = "创建人")
	@TableField("create_by_id")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	@TableField("create_by_name")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	@TableField("update_time")
	private Date updateTime;

	@ApiModelProperty(value = "修改人")
	@TableField("update_by_id")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	@TableField("update_by_name")
	private String updateByName;

	@ApiModelProperty(value = "启用时间")
	@TableField("enable_time")
	private Date enableTime;

	@ApiModelProperty(value = "启用人")
	@TableField("enable_by_id")
	private Long enableById;

	@ApiModelProperty(value = "启用人姓名")
	@TableField("enable_by_name")
	private String enableByName;

	@ApiModelProperty(value = "公司ID")
	@TableField("company_id")
	private Long companyId;

	@ApiModelProperty(value = "部门ID")
	@TableField("org_id")
	private Long orgId;

	@ApiModelProperty(value = "站点ID")
	@TableField("site_id")
	private Long siteId;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
