package com.yizhi.application.service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.PointActivity;

/**
 * <p>
 * 活动策略 服务类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
public interface PointActivityService extends IService<PointActivity> {
	
	/**
	 * 积分活动策略新增
	 * @param pointActivity
	 * @return
	 */
	Long insertDetail(PointActivity pointActivity);

	/**
	 * 积分活动策略删除
	 * @param pointActivity
	 * @return
	 */
	Long deleteDetailById(PointActivity pointActivity);
	
	/**
	 * 积分活动策略启用
	 * @param id
	 * @return
	 */
	Boolean pointUp(Long id, Long accountId, String accountName);
	
	/**
	 * 积分活动策略停用
	 * @param id
	 * @return
	 */
	Boolean pointDown(Long id, Long accountId, String accountName);
	
	/**
	 * 积分活动策略查询、分页列表
	 * @param page
	 * @param map
	 * @return
	 */
	Page<PointActivity> activityList(Page<PointActivity> page, Map<String, Object> map);

	/**
	 * 获取正在进行的积分活动
	 * @param createPointTime
	 * @return
	 */
	List<PointActivity> getPointActivity(Date createPointTime, Long companyId, Long siteId);

}
