package com.yizhi.application.util;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.publish.CloudEventPublisher;
import com.yizhi.message.application.enums.EvenType;
import com.yizhi.message.application.enums.RelationType;
import com.yizhi.message.application.vo.MessageRemindVo;
import com.yizhi.message.application.vo.TaskVo;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class PointEvenSendMessage {


    @Autowired
    private CloudEventPublisher cloudEventPublisher;

    private Logger logger = LoggerFactory.getLogger(PointEvenSendMessage.class);

    /**
     * 触发事件,
     *
     * @param taskVo    业务参数对象
     * @param accountId
     */
    public void evenSendMessage(Long pointUserId, TaskVo taskVo, Long accountId, EvenType evenType, RequestContext context) {

        if (taskVo != null) {

            MessageRemindVo vo = new MessageRemindVo();
            vo.setVisibleRange(1);
            vo.setMessageId(evenType.getKey());
            vo.setMessageType(3);
            vo.setRelationId(pointUserId);
            vo.setRelationType(RelationType.JF.getKey());
            vo.setSendType(1);
            //定时任务默认五分钟执行一次   这里默认暂时不延迟时间
            vo.setSendTime(DateUtils.addMinutes(new Date(), 0));
            if (accountId != null) {
                vo.setAccountId(accountId);
            }
            vo.setRequestContext(context);
            com.yizhi.core.application.vo.TaskVo taskVo1 = new com.yizhi.core.application.vo.TaskVo();
            BeanUtils.copyProperties(taskVo,taskVo1);
            vo.setTaskVo(taskVo1);
            try {
                //临时取消触发功能
//                cloudEventPublisher.publish(Constans.MESSAGE_QUEUE, new EventWrapper<MessageRemindVo>(null, vo));
            } catch (Exception e) {
                e.printStackTrace();
                logger.error("发送消息失败=====================", e);
            }

        }
    }

}
