package com.yizhi.research.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.research.application.vo.domain.StatisticsResearchVo;
import com.yizhi.research.application.vo.report.DownloadParamsVoOnTime;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "research")
public interface ResearchReportClient {
    /**
     * 异步加载统计
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping("/statisticsResearch/asynchronous/load/data")
    public Response<String> asynchronousResearch(@RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate);

    @GetMapping("/statisticsResearch/group")
    Page<StatisticsResearchVo> researchGroup(@RequestParam(name = "startDate", required = false) String startDate,
                                             @RequestParam(name = "endDate", required = false) String endDate,
                                             @RequestParam(name = "kwd", required = false) String kwd,
                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
                                             @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                             @RequestParam(name= "companyId" ,required = true) Long companyId,
                                             @RequestParam(name= "orgIds" ,required = false) List<Long> orgIds,
                                             @RequestParam(name= "siteId" ,required = true) Long siteId);
    @GetMapping("/statisticsResearch/group/view")
    Page<StatisticsResearchVo> researchGroupView(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo);

    @GetMapping("/statisticsResearch/group/view/state/count")
    StatisticsResearchVo getCanStateCount(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state);


    @GetMapping("/statisticsResearch/export/research/accounts")
    List<StatisticsResearchVo> researchList(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state);

    @ApiOperation(value = "下载调研参与人员的统计个数" ,notes = "下载参与人员的统计个数" ,response = StatisticsResearchVo.class)
    @GetMapping("/statisticsResearch/export/research/accounts/count")
    public Integer researchViewCount(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state
    );
    @ApiOperation(value = "调研参与人员的统计分页列表" ,notes = "调研参与人员的统计分页列表" ,response = StatisticsResearchVo.class)
    @GetMapping("/statisticsResearch/group/views")
    List<StatisticsResearchVo> researchViews(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo);

    @ApiOperation (value = "导出调研明细", notes = "导出调研明细")
    @PostMapping("/statisticsResearch/details/Excel/onTime")
    public String reportResearchDetails(@RequestBody DownloadParamsVoOnTime vo);

    @ApiOperation (value = "导出调研分析", notes = "导出调研分析")
    @PostMapping("/statisticsResearch/analyze/Excel/onTime")
    public String reportResearchanalyze(@RequestBody DownloadParamsVoOnTime vo);


}


