package com.yizhi.research.application.vo.api;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/19 11:02
 */
@Data
@Api(tags = "AnswerVo", description = "调研问卷答案vo")
public class AnswerVo {

    @ApiModelProperty(value = "所属调研id", required = true)
    private Long researchId;

    @ApiModelProperty(value = "调研终端类型，1微信 2PC 3APP")
    private Integer terminalType;

    @ApiModelProperty(value = "开始时间", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty(value = "提交时间", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date submitTime;

    @ApiModelProperty(value = "问题集合", required = true)
    private List<AnswerQuestionVo> questions;


}
