package com.yizhi.research.application.vo.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author: shengchenglong
 * @Date: 2018/5/8 09:57
 */
@ApiModel("查看提交的问卷答案--答案下的问题选项")
@Data
public class ViewAnswerQuestionOptionVo {


    @ApiModelProperty(value = "选项ID主键")
    private Long id;

    @ApiModelProperty(value = "选项排序，不能为空")
    private Integer no;

    @ApiModelProperty(value = "选项内容，最多支持输入500汉字")
    private String content;

    @ApiModelProperty(value = "跳题题号（单选题有效），问题设置了跳题才有效，大于当前题号")
    private Integer jumpNum;

    @ApiModelProperty(value = "是否正确答案（选择题有效），0不是 1是")
    private Integer correct;

    @ApiModelProperty(value = "是否允许填空")
    private Integer editable;

    @ApiModelProperty(value = "是否被学员选中")
    private Boolean answerChecked = false;

    @ApiModelProperty(value = "学员回答的内容", notes = "问答题有效")
    private String answerContent;

    @ApiModelProperty(value = "学员打分分数", notes = "打分题有效")
    private Integer answerScore;

    @ApiModelProperty(value = "最大分数",notes = "打分题有效")
    private Integer maxScore = 0;

    @ApiModelProperty(value = "最小分数",notes = "打分题有效")
    private Integer minScore = 0;

    @ApiModelProperty(value ="总分", notes = "总分")
    private Integer totalSocre = 0;

    @ApiModelProperty(value = "选中个数" , notes = "选中个数")
    private Integer checkCount = 0;


    @ApiModelProperty(value = "是否是其他选项")
    private Integer isOther = 0;







}
