package com.yizhi.research.application.vo.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/5/8 09:40
 */
@ApiModel("查看提交的问卷答案--答案主体")
@Data
public class ViewAnswerVo {

    @ApiModelProperty(value = "答卷ID，主键")
    private Long id;

    @ApiModelProperty(value = "调研名称")
    private String name;

    @ApiModelProperty(value = "用户的id")
    private Long accountId;

    @ApiModelProperty(value = "开始时间，用户进入考试的时间")
    private Date startTime;

    @ApiModelProperty(value = "提交时间")
    private Date submitTime;

    @ApiModelProperty(value = "调研用时，分钟")
    private Integer duration;

    @ApiModelProperty(value = "调研终端类型，1微信 2PC 3APP")
    private Integer terminalType;

    @ApiModelProperty(value = "答案下的问题集合")
    private List<ViewAnswerQuestionVo> answerQuestions;

}
