package com.yizhi.research.application.vo.domain;

import java.io.Serializable;

import java.util.Date;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 提醒时间
 * </p>
 *
 * @author shengchenglong123
 * @since 2018-03-14
 */
@Data
@Api(tags = "TrResearchRemindVo", description = "提醒时间")
@TableName("tr_research_remind")
public class TrResearchRemindVo extends Model<TrResearchRemindVo> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键id")
    
	private Long id;

    @ApiModelProperty(value = "关联调研id")
	
	private Long researchId;

	@ApiModelProperty(value = "1：开始之前，2：开始之后，3：自定义时间")
	
	private Integer type;

	@ApiModelProperty(value = "type=1或type=2：相差秒数")
	
	private Long seconds;

	@ApiModelProperty(value = "是否删除（0：未删，1：已删）")
	
	private Integer deleted;

    @ApiModelProperty(value = "提醒时间")
	
	private Date time;

    @ApiModelProperty(value = "创建时间")
	
	private Date createTime;

    @ApiModelProperty(value = "创建人ID")
	
	private Long createById;

    @ApiModelProperty(value = "创建人姓名")
	
	private String createByName;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
