package com.yizhi.research.application.vo.domain;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@Api(tags = "VoteRankingListVo", description = "调研排行榜")
public class VoteRankingListVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "问题主键ID，主键")
    private Long id;

    @ApiModelProperty(value = "存放附件路径，附件格式：音频、视频、图片")
    private String contentAppendixUrl;
 
    @ApiModelProperty(value = "问题内容")
    private String content;

    @ApiModelProperty(value = "选项内容")
    private String optionContent;
    
    @ApiModelProperty(value = "关键字")
    private String keywords;

    @ApiModelProperty(value = "序号")
    private Integer no;
    
    @ApiModelProperty(value = "剩余投票次数")
    private Integer voteNum = 0;
    
    @ApiModelProperty(value = "投票量")
    private Integer voteCount = 0;
    
    @ApiModelProperty(value = "true=已投票;false未投票")
    private Boolean answerState;

    @ApiModelProperty(value = "展示样式")
    private Integer styleType;

    @ApiModelProperty(value = "展示样式")
    private String logoSrc;
}
