package com.yizhi.research.application.vo.manage;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 选择题选项vo，包括单选、多选
 *
 * @Author: shengchenglong
 * @Date: 2018/3/14 09:34
 */
@Data
@Api(tags = "QuestionOptionVo", description = "选择题选项vo，包括单选、多选\n打分题vo")
public class QuestionOptionVo {

    @ApiModelProperty(value = "id", notes = "修改时传")
    private Long id;

    @ApiModelProperty(value = "所有题型有效：选项号，不能为空", required = true)
    private Integer no;

    @ApiModelProperty(value = "单选和多选有效：允许填空，0不允许 1允许，默认0")
    private Integer editable;

    @ApiModelProperty(value = "单选和多选有效：0不是，1是，默认不是")
    private Integer correct;

    @ApiModelProperty(value = "单选题有效：跳题题号，问题设置了跳题才有效，大于当前题号")
    private Integer jumpNum;

    @ApiModelProperty(value = "选项内容，最多支持输入500汉字")
    private String content;

    @ApiModelProperty(value = "打分题有效：最高分值")
    private Integer maxScore;

    @ApiModelProperty(value = "打分题有效：最低分值")
    private Integer minScore;

    @ApiModelProperty(value = "是否是必填 0 不是 1是")
    private Integer required;

    @ApiModelProperty(value = "是否是其它选项 0 不是 1是")
    private Integer isOther;


}
