package com.yizhi.research.application.vo.manage;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/14 17:05
 */
@Data
@Api(tags = "RemindVo", description = "提醒vo")
public class RemindVo {

    @ApiModelProperty(value = "开启邮件提醒（0：否，1：是）", required = true)
    private Integer enableMail;

    @ApiModelProperty(value = "开启站内消息提醒（0：否，1：是）", required = true)
    private Integer enableApp;

    @ApiModelProperty(value = "邮件模板id")
    private Long mailTemplateId;

    @ApiModelProperty(value = "站内消息模板id")
    private Long appTemplateId;

    @ApiModelProperty(value = "提醒内容")
    private String content;

    @ApiModelProperty(value = "提醒时间集合")
    private List<RemindTimeVo> remindTimes;

}
