package com.yizhi.research.application.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.research.application.download.DownloadResearchAnalyze;
import com.yizhi.research.application.download.DownloadResearchAnalyze1;
import com.yizhi.research.application.download.DownloadResearchDetails;
import com.yizhi.research.application.service.StatisticsResearchService;
import com.yizhi.research.application.vo.domain.StatisticsResearch;
import com.yizhi.research.application.vo.report.DownloadParamsVoOnTime;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/statisticsResearch")
public class StatisticsResearchController {
    @Autowired
    private StatisticsResearchRun statisticsResearchRun;

    @Autowired
    private StatisticsResearchService statisticsResearchService;

    @Autowired
    private DownloadResearchDetails downloadResearchDetails;

    @Autowired
    private DownloadResearchAnalyze downloadResearchAnalyze;
    @Autowired
    private DownloadResearchAnalyze1 downloadResearchAnalyze1;

    private Logger LOGGER = LoggerFactory.getLogger(StatisticsResearchController.class);

    @GetMapping("/asynchronous/load/data")
    public Response<String> asynchronousResearch(@RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate){
        Map<String,Object> map=new HashMap<String,Object>();
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        statisticsResearchRun.execute(map,true);
        return Response.ok();
    }


    @ApiOperation(value = "调研统计", notes = "调研统计", response = StatisticsResearch.class)
    @GetMapping("/group")
    public Page<StatisticsResearch> researchGroup(@RequestParam(name = "startDate", required = false) String startDate,
                                                  @RequestParam(name = "endDate", required = false) String endDate,
                                                  @RequestParam(name = "kwd", required = false) String kwd,
                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
                                                  @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                  @RequestParam(name= "companyId" ,required = true) Long companyId,
                                                  @RequestParam(name= "orgIds" ,required = false) List<Long> orgIds,
                                                  @RequestParam(name= "siteId" ,required = true) Long siteId){
        return statisticsResearchService.researchGroup(startDate,endDate,kwd,pageSize,pageNo,companyId,orgIds,siteId);
    }

    @ApiOperation(value = "调研参与人员的统计" ,notes = "调研参与人员的统计" ,response =StatisticsResearch.class)
    @GetMapping("/group/view")
    public Page<StatisticsResearch> researchGroupView(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
        return statisticsResearchService.selectResearchView(researchId,startDate,endDate,orgNameorOrgCode,accountName,state,pageNo,pageSize);

    }
    @GetMapping("/group/view/state/count")
    public StatisticsResearch getCanStateCount(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state
            ){
        return statisticsResearchService.selectJoinCount(researchId,startDate,endDate,orgNameorOrgCode,accountName,state);
    }
    @ApiOperation(value = "下载调研参与人员的统计" ,notes = "下载参与人员的统计" ,response =StatisticsResearch.class)
    @GetMapping("/export/research/accounts")
    public List<StatisticsResearch> researchList(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state){
        return statisticsResearchService.researchViewList(researchId,orgNameorOrgCode,accountName,state,startDate,endDate);
    }
    @ApiOperation(value = "下载调研参与人员的统计个数" ,notes = "下载参与人员的统计个数" ,response =StatisticsResearch.class)
    @GetMapping("/export/research/accounts/count")
    public Integer researchViewCount(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state
    ){
        return statisticsResearchService.selectResearchViewCount(researchId,startDate,endDate,orgNameorOrgCode,accountName,state) ;
    }

    @ApiOperation(value = "调研参与人员的统计" ,notes = "调研参与人员的统计" ,response =StatisticsResearch.class)
    @GetMapping("/group/views")
    public List<StatisticsResearch> researchViews(
            @RequestParam(name = "startDate", required = false) String startDate,
            @RequestParam(name = "endDate", required = false) String endDate,
            @RequestParam(name= "researchId" ,required = true) Long researchId,
            @RequestParam(name = "orgNameorOrgCode" ,required = false) String orgNameorOrgCode,
            @RequestParam(name = "accountName" ,required = false )String accountName,
            @RequestParam(name= "state" ,required = false) Integer state,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
        return statisticsResearchService.researchViews(researchId,startDate,endDate,orgNameorOrgCode,accountName,state,pageNo,pageSize);
    }

    @ApiOperation (value = "实时导出调研明细", notes = "导出调研明细")
    @PostMapping("/details/Excel/onTime")
    public String reportResearchDetails(@RequestBody DownloadParamsVoOnTime vo) {

        try {
            downloadResearchDetails.execute(vo, true);
            return "任务名称：" + vo.getTaskName() + ",任务序号:" + vo.getSerialNo();
        } catch (Exception e) {
            LOGGER.error("", e);
            return null;
        }
    }

    @ApiOperation (value = "实时导出调研分析统计", notes = "导出调研分析统计")
    @PostMapping ("/analyze/Excel/onTime")
    public String reportResearchanalyze(@RequestBody DownloadParamsVoOnTime vo) {

        try {
            downloadResearchAnalyze1.execute(vo, true);
//            downloadResearchAnalyze.execute(vo, true);
            return "任务名称：" + vo.getTaskName() + ",任务序号:" + vo.getSerialNo();
        } catch (Exception e) {
            LOGGER.error("", e);
            return null;
        }
    }
}
