package com.yizhi.research.application.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.research.application.mapper.TrResearchAnswerMapper;
import com.yizhi.research.application.model.AnswerModel;
import com.yizhi.research.application.service.ITrResearchAnswerService;
import com.yizhi.research.application.vo.StatisticResearchMetadataVo;
import com.yizhi.research.application.vo.api.ViewAnswerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 答卷 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@RestController
@RequestMapping("/researchAnswer")
public class TrResearchAnswerController {

    @Autowired
    private ITrResearchAnswerService researchAnswerService;
    @Autowired
    private TrResearchAnswerMapper trResearchAnswerMapper;

    /**
     * 学员提交答案
     * @param answerModel
     * @return
     * @throws Exception
     */
    @PostMapping("/submit")
    public Integer submitAnswer(@RequestBody AnswerModel answerModel) throws Exception {
        return researchAnswerService.submitAnswer(answerModel);
    }

    @GetMapping("/view")
    public ViewAnswerVo viewResearch(@RequestParam("researchId") Long researchId, @RequestParam("accountId") Long accountId) {
        return researchAnswerService.apiViewAnswer(researchId, accountId);
    }

    /**
     * 查看调研下所有的答卷
     * @param researchId
     * @param
     * @return
     */
    @GetMapping("/views")
    public Page<ViewAnswerVo> viewAnswers(@RequestParam("researchId") Long researchId,
                                          @RequestParam("pageNo") Integer pageNo,
                                          @RequestParam("pageSize") Integer pageSize){
        return researchAnswerService.apiViewAnswers(researchId,pageNo,pageSize);
    }

    @GetMapping("/views/list")
    public List<ViewAnswerVo> viewAnswersList(@RequestParam("researchId") Long researchId,
                                          @RequestParam("pageNo") Integer pageNo,
                                          @RequestParam("pageSize") Integer pageSize){
        return researchAnswerService.viewAnswerVoList(researchId,pageNo,pageSize);
    }

    @GetMapping("/views/count")
    public Integer viewAnswersCount(@RequestParam("researchId") Long researchId){
        return researchAnswerService.apiViewAnswersCount(researchId);
    }

    @GetMapping("/view/list")
    public List<ViewAnswerVo> viewList(@RequestParam("researchId") Long researchId){
        return researchAnswerService.viewList(researchId);
    }

    /**
     * 根据调研answer的创建时间、调研id、已完成状态查询，
     * @param researchId
     * @param currentDate
     * @return
     */
    @GetMapping("/selectLearnRecord")
   public List<StatisticResearchMetadataVo> selectLearnRecord(@RequestParam("researchId")Long researchId,
                                                              @RequestParam("startDate")String startDate,
                                                              @RequestParam("endDate")String endDate){
        return trResearchAnswerMapper.selectLearnRecord(researchId,startDate,endDate);
    }

}

