package com.yizhi.research.application.controller;


import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.research.application.service.IResearchService;
import com.yizhi.research.application.service.ITrResearchAuthorizeService;

import com.yizhi.research.application.vo.VisibleRangeExport;
import com.yizhi.research.application.vo.domain.TrResearchAuthorize;
import com.yizhi.research.application.vo.domain.TrResearchAuthorizeVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 调研用户范围 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@RestController
@RequestMapping("/researchAuthorize")
public class TrResearchAuthorizeController {

    @Autowired
    private ITrResearchAuthorizeService iTrResearchAuthorizeService;
    @Autowired
    private IResearchService researchService;

    @GetMapping("/researchId/get")
    public List<TrResearchAuthorize> getResearchAuthorize(@RequestParam("researchId") Long researchId) {
        TrResearchAuthorize example = new TrResearchAuthorize();
        example.setResearchId(researchId);
        return example.selectList(new EntityWrapper(example));
    }

    @PostMapping("/researchId/insert")
    public Boolean insertResearchAuthorize(@RequestBody List<TrResearchAuthorizeVo> trResearchAuthorizes){
        List<TrResearchAuthorize> list=new ArrayList<>();
        for (TrResearchAuthorizeVo trv:trResearchAuthorizes
             ) {
            TrResearchAuthorize t=new TrResearchAuthorize();
            BeanUtils.copyProperties(trv,t);
            list.add(t);
        }
        return iTrResearchAuthorizeService.insertAll(list);
    }

    
    
    @ApiOperation(value="可见范围导出",notes="可见范围导出")
    @GetMapping("/export/visiblRange")
    public VisibleRangeExport vsibleRangeExport(@ApiParam(value="researchId",name="调研的Id",required=true) @RequestParam(name="researchId",required=true) Long researchId) {
    	return researchService.vsibleRangeExport(researchId);
    }
}

