package com.yizhi.research.application.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.research.application.model.ModifyQuestionModel;
import com.yizhi.research.application.service.ITrResearchQuestionOptionService;
import com.yizhi.research.application.service.ITrResearchQuestionService;
import com.yizhi.research.application.vo.api.MyQuestion;
import com.yizhi.research.application.vo.api.QuestionJumpVo;
import com.yizhi.research.application.vo.domain.TrResearchQuestion;
import com.yizhi.research.application.vo.domain.TrResearchQuestionOption;
import com.yizhi.research.application.vo.domain.TrResearchQuestionOptionVo;
import com.yizhi.research.application.vo.domain.TrResearchQuestionVo;
import com.yizhi.research.application.vo.domain.VoteRankingVo;

import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 问题 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@RestController
@RequestMapping("/researchQuestion")
public class TrResearchQuestionController {

    private static final Logger LOGGER = LoggerFactory.getLogger(TrResearchQuestionController.class);

    @Autowired
    private ITrResearchQuestionService researchQuestionService;

    @Autowired
    private ITrResearchQuestionOptionService researchQuestionOptionServiceService;

    /**
     * 批量插入问题
     *
     * @param questions
     * @return
     */
    @PostMapping("/batch/insert")
    public int batchInsert(@RequestBody List<TrResearchQuestionVo> questions) {
        if (CollectionUtils.isEmpty(questions)) {
            return 0;
        }
        List<TrResearchQuestion> list=new ArrayList<>();
        for (TrResearchQuestionVo trqv:questions
             ) {
            TrResearchQuestion tr=new TrResearchQuestion();
            BeanUtils.copyProperties(trqv,tr);
            List<TrResearchQuestionOptionVo> list1=trqv.getOptions();
            List<TrResearchQuestionOption> list2=new ArrayList<>();
            if (!CollectionUtils.isEmpty(list1)) {
                for (TrResearchQuestionOptionVo j : list1
                ) {
                    TrResearchQuestionOption trr = new TrResearchQuestionOption();
                    BeanUtils.copyProperties(j, trr);
                    list2.add(trr);
                }
            }
            tr.setOptions(list2);
            list.add(tr);
        }
        return researchQuestionService.batchInsert(list);
    }

    /**
     * 问题更新
     * deletedIds: 删除的问题的id集合
     * questions： 新增的问题，修改的问题（修改仅仅涉及序号）
     *
     * @param model
     * @return
     */
    @PostMapping("/update")
    public int batchUpdate(@RequestBody ModifyQuestionModel model) throws Exception {
        return researchQuestionService.batchUpdate(model);
    }

    @PostMapping("/updateNo")
    public int updateNo(@RequestBody QuestionJumpVo vo) {
        return researchQuestionService.updateNo(vo);
    }

    /**
     * 分页查询 一个调研下面的问题
     *
     * @param page 只有一个
     * @return
     */
    @GetMapping("/page/list")
    public List<TrResearchQuestion> listPage(@RequestBody Page<TrResearchQuestion> page) {
        Map<String, Object> map = page.getCondition();
        map.put("pageNo", page.getCurrent());
        map.put("pageSize", page.getSize());
        return researchQuestionService.listPage(map);
    }

    /**
     * 根据调研id查询所有
     *
     * @param researchId
     * @return
     */
    @GetMapping("/list")
    public List<TrResearchQuestion> listAll(@RequestParam("researchId") Long researchId) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("researchId", researchId);
        return researchQuestionService.listPage(map);
    }

    @GetMapping("/listByPage")
    public List<TrResearchQuestion> listByPage(
            @RequestParam(value = "pageSize", required = false) Integer pageSize,
            @RequestParam(value = "pageNo", required = false) Integer pageNo,
            @RequestParam("researchId") Long researchId) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("pageSize", pageSize);
        map.put("pageNo", pageNo);
        map.put("researchId", researchId);
        return researchQuestionService.listPage(map);
    }

    @GetMapping("/list/all")
    public List<TrResearchQuestion> list(@RequestParam("researchId") Long researchId) {
        return researchQuestionService.listAll(researchId);
    }

    /**
     * 选择跳题时的问题列表
     *
     * @param id 需要跳题的问题id
     * @return
     */
    @GetMapping("/jump/question/list")
    public List<TrResearchQuestion> listAllForJump(@RequestParam("id") Long id) {
        return researchQuestionService.listAllForJump(id);
    }

    /**
     * 调研逐题显示下一题或者上一题
     */
    @GetMapping("/last/next")
    public MyQuestion lastAndNext(
            @RequestBody MyQuestion myQuestion
    ) {
        return researchQuestionService.lastAndNext(myQuestion);
    }

    @PostMapping("/jump/question/update")
    Integer updateQuestionJump(@RequestBody QuestionJumpVo vo) {
        return researchQuestionService.updateQuestionJump(vo);
    }

    @GetMapping("/option/get")
    Map<String, Object> getOptionByQuestionId(@RequestParam("questionId") Long id) {
        return researchQuestionOptionServiceService.getOptionByQuestionId(id);
    }

    /**
     * 查找调研完成学员id
     *
     * @param researchId
     * @param companyId
     * @param siteId
     * @return
     */
    @GetMapping("/getFinishedAccountIds")
    List<Long> getFinishedAccountIds(@RequestParam("researchId") Long researchId,
                                     @RequestParam("companyId") Long companyId,
                                     @RequestParam("siteId") Long siteId) {
        return researchQuestionService.getFinishedAccountIds(researchId, companyId, siteId);
    }

    /**
     * 获取投票结果
     * @param researchId
     * @return
     */
    @GetMapping("/getVoteResult")
    VoteRankingVo getVoteResult(@RequestParam("researchId") Long researchId,
                                @RequestParam(value = "pageNo", required = false) Integer pageNo,
                                @RequestParam(value = "pageSize", required = false) Integer pageSize) {
    	return researchQuestionService.getVoteResult(researchId, pageNo, pageSize);
    }
    
    /**
     * 获取投票排行榜
     * @param researchId
     * @return
     */
    @GetMapping("/getVoteTop")
    VoteRankingVo getVoteTop(@RequestParam("researchId") Long researchId) {
    	return researchQuestionService.getVoteTop(researchId);
    }

    @GetMapping("/deleteByResearchIdAndQueId")
    public int deleteByResearchIdAndQueId(@RequestParam("id") Long id, @RequestParam("researchId") Long researchId) {
       return researchQuestionService.deleteByResearchIdAndQueId(id, researchId);
    }
}

