package com.yizhi.research.application.controller;


import com.yizhi.research.application.service.ITrResearchQuestionOptionService;
import com.yizhi.research.application.vo.domain.TrResearchQuestionOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 只对题型是：单选题、多选题和打分题 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@RestController
@RequestMapping("/trResearchQuestionOption")
public class TrResearchQuestionOptionController {

    @Autowired
    ITrResearchQuestionOptionService iTrResearchQuestionOptionService;

    @GetMapping("/all")
    public List<TrResearchQuestionOption> listAll(@RequestParam("researchId") Long researchId) {
        return iTrResearchQuestionOptionService.listAll(researchId);
    }
    @GetMapping("/option/get")
    public Map<String,Object> getOptionByQuestionId(@RequestParam("questionId") Long id){
        return iTrResearchQuestionOptionService.getOptionByQuestionId(id);
    }

}

