package com.yizhi.research.application.download;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.research.application.mapper.TrResearchAnswerMapper;
import com.yizhi.research.application.mapper.TrResearchAnswerQuestionMapper;
import com.yizhi.research.application.mapper.TrResearchAnswerQuestionResultMapper;
import com.yizhi.research.application.mapper.TrResearchQuestionMapper;
import com.yizhi.research.application.util.WorkUtil;
import com.yizhi.research.application.service.*;
import com.yizhi.research.application.vo.domain.*;
import com.yizhi.research.application.vo.report.DownloadParamsVoOnTime;
import com.yizhi.research.application.vo.report.ReportResearchAnalyze;
import com.yizhi.research.application.vo.report.ResearchGroupViewVo;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.system.application.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.yizhi.core.application.log.TaskLogEvent.working;
import static java.math.BigDecimal.ROUND_HALF_DOWN;

@Component
public class DownloadResearchAnalyze1 extends AbstractDefaultTask<String, DownloadParamsVoOnTime> {

    private static final Logger logger = LoggerFactory.getLogger(DownloadResearchAnalyze1.class);

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Autowired
    private WorkUtil workUtil;
    @Autowired
    private ITrResearchQuestionService researchQuestionService;
    @Autowired
    ITrResearchQuestionOptionService iTrResearchQuestionOptionService;
    @Autowired
    private ITrResearchAnswerService researchAnswerService;
    @Autowired
    private TrResearchAnswerMapper trResearchAnswerMapper;
    @Autowired
    private ReportClient reportClient;
    @Autowired
    private IResearchService researchService;
    @Autowired
    private AccountClient accountClient;
    @Autowired
    private TrResearchQuestionMapper researchQuestionMapper;
    @Autowired
    private TrResearchAnswerQuestionMapper researchAnswerQuestionMapper;
    @Autowired
    private TrResearchAnswerQuestionResultMapper researchQuestionResultMapper;
    @Autowired
    private ITrResearchAnswerQuestionService trResearchAnswerQuestionService;

    @Override
    protected String execute(DownloadParamsVoOnTime vo) {
        Long s12 = System.currentTimeMillis();

        Long researchId = vo.getResearchId();
        String researchName = vo.getResesrchName();
        RequestContext context = vo.getContext();
        String taskName = vo.getTaskName();
        String serialNo = vo.getSerialNo();
        Long taskId = vo.getTaskId();
        Long siteId = context.getSiteId();

        Date submitTime = new Date();
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, context.getAccountId(), submitTime, context.getSiteId(), context.getCompanyId());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        working(taskContext);


        // 根据researchId查询该调研所有问题集合
        TrResearchQuestion question = new TrResearchQuestion();
        question.setDeleted(0);
        question.setResearchId(researchId);
        EntityWrapper<TrResearchQuestion> questionEW = new EntityWrapper<>(question);
        questionEW.orderBy("no", true);
        List<TrResearchQuestion> questions = researchQuestionMapper.selectList(questionEW);


        //获取问题选项列表
        List<TrResearchQuestionOption> trResearchQuestionOptions = iTrResearchQuestionOptionService.listAll(researchId);
        if (trResearchQuestionOptions == null) {
            trResearchQuestionOptions = new ArrayList<>();
        }

        // 以问题id为key，问题选项为value的map
        Map<Long, List<TrResearchQuestionOption>> questionOptionMap = new HashMap<>();
        for (TrResearchQuestionOption option : trResearchQuestionOptions) {
            if (!questionOptionMap.containsKey(option.getQuestionId())) {
                List<TrResearchQuestionOption> list = new ArrayList<>();
                list.add(option);
                questionOptionMap.put(option.getQuestionId(), list);
            } else {
                questionOptionMap.get(option.getQuestionId()).add(option);
            }
        }

        // 根据调研id、用户id，查出答卷与问题关联关系的集合
        TrResearchAnswerQuestion answerQuestion = new TrResearchAnswerQuestion();
        answerQuestion.setResearchId(researchId);
        EntityWrapper<TrResearchAnswerQuestion> answerQuestionEW = new EntityWrapper<TrResearchAnswerQuestion>(answerQuestion);
        List<TrResearchAnswerQuestion> answerQuestions = researchAnswerQuestionMapper.selectList(answerQuestionEW);

        // 以问题id为key，问题答卷关联ids为value的map
        Map<Long, List<Long>> answerQuestionMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(answerQuestions)) {
            answerQuestions.forEach(a -> {
                if (!answerQuestionMap.containsKey(a.getQuestionId())) {
                    List<Long> answerQuestionIds = new ArrayList<>();
                    answerQuestionIds.add(a.getId());
                    answerQuestionMap.put(a.getQuestionId(), answerQuestionIds);
                } else {
                    answerQuestionMap.get(a.getQuestionId()).add(a.getId());
                }
            });
        }


        // 根据答卷id，查出该学员的问题答案集合
        TrResearchAnswerQuestionResult questionResult = new TrResearchAnswerQuestionResult();
        questionResult.setResearchId(researchId);
        List<TrResearchAnswerQuestionResult> questionResults = researchQuestionResultMapper.selectList(new EntityWrapper<TrResearchAnswerQuestionResult>(questionResult));
        Map<Long, List<TrResearchAnswerQuestionResult>> answerResultMap = new HashMap<>();

        // 以问题答卷关联id为key，问题答案为value的 map
        if (!org.springframework.util.CollectionUtils.isEmpty(questionResults)) {
            for (TrResearchAnswerQuestionResult result : questionResults) {
                if (answerResultMap.get(result.getAnswerQuestionId()) == null) {
                    List<TrResearchAnswerQuestionResult> list = new ArrayList<>();
                    list.add(result);
                    answerResultMap.put(result.getAnswerQuestionId(), list);
                } else {
                    answerResultMap.get(result.getAnswerQuestionId()).add(result);
                }
            }
        }
        //以分数为key,分数位置为value
        Map<Integer, Integer> scoreIndexMap = new HashMap<>();
        Integer scoreTem = 10;
        Integer indexTem = 1;
        for (indexTem = 1; indexTem <= 11; indexTem++) {
            scoreIndexMap.put(scoreTem, indexTem);
            scoreTem--;
        }


//        //这里主要获取问答题需要的字段数据 name、submitTime
        List<ResearchGroupViewVo> researchGroupViewVos = trResearchAnswerMapper.queryAnswerRecord(researchId, siteId);

        researchGroupViewVos = fillGroupViewVo(researchGroupViewVos);

        //组装 以用户id为key ,用户答题主体记录为value的map
        Map<Long, ResearchGroupViewVo> statisticsResearchMap = new HashMap<Long, ResearchGroupViewVo>();
        for (ResearchGroupViewVo researchGroupViewVo : researchGroupViewVos) {
            if (researchGroupViewVo == null) {
                continue;
            }
            statisticsResearchMap.put(researchGroupViewVo.getAccountId(), researchGroupViewVo);
        }


        String upLoadUrl = null;
        String requestPath = FileConstant.SAVE_PATH;
//        String requestPath = "E\\";
        File fileDir = new File(requestPath);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }

        XSSFWorkbook workbook = new XSSFWorkbook();
        //创建单元格格式
        XSSFCellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);//创建居左格式
        Cell cell;
        String sheetName = workUtil.chechPattonPattern(researchName + "调研分析表");
        XSSFSheet sheet = workbook.createSheet(sheetName);

        //创建第一行
        XSSFRow row = sheet.createRow((int) 0);
        cell = row.createCell(0);
        cell.setCellValue(researchName);

        //创建第二行
        row = sheet.createRow((int) 1);
        cell = row.createCell(0);
        String deadline = format.format(submitTime);
        cell.setCellValue("统计周期:" + "截止" + deadline);

        //获取实际参加人数
        Integer realJoinNum = (researchGroupViewVos == null ? 0 : researchGroupViewVos.size());
        Integer canjoinNum = 0;

        //获取可参加人数
        canjoinNum = queryCanJoinNum(researchId, context);

        ReportResearchAnalyze reportResearchAnalyze = new ReportResearchAnalyze();
        reportResearchAnalyze.setJoinCount(canjoinNum == null ? 0 : canjoinNum);
        reportResearchAnalyze.setRealJoinCount(realJoinNum);
        reportResearchAnalyze.setSubmitCount(realJoinNum);
        reportResearchAnalyze.setQuestionCount(questions == null ? 0 : questions.size());


        //创建第三行
        row = sheet.createRow((int) 2);
        row.createCell(0).setCellValue("题目总数:" + reportResearchAnalyze.getQuestionCount());
        row.createCell(1).setCellValue("提交问卷份数:" + reportResearchAnalyze.getSubmitCount());
        row.createCell(2).setCellValue("可参加人数:" + reportResearchAnalyze.getJoinCount());
        row.createCell(3).setCellValue("实际参加人数：" + reportResearchAnalyze.getRealJoinCount());

        try {


//            //答卷的问题

            BigDecimal dou;
            BigDecimal b = new BigDecimal(100);
            int s = 0;


            //第四行组装数据开始
            int index = 3;
            Long questionId = null;
            if (CollectionUtils.isNotEmpty(questions)) {
                for (TrResearchQuestion trResearchQuestion : questions) {
                    row = sheet.createRow((int) index);
                    index++;
                    String typeName = null;
                    switch (trResearchQuestion.getType()) {
                        case 1:
                            typeName = "、" + "(单选题)";
                            break;
                        case 2:
                            typeName = "、" + "(多选题)";
                            break;
                        case 3:
                            typeName = "、" + "(问答题)";
                            break;
                        case 4:
                            typeName = "、" + "(打分题)";
                            break;
                    }
                    //每道题的题目
                    row.createCell(0).setCellValue(trResearchQuestion.getNo() + typeName + trResearchQuestion.getContent());

                    questionId = trResearchQuestion.getId();
                    List<Long> answerQuestionIds = answerQuestionMap.get(questionId);
                    Integer valid = answerQuestionIds == null ? 0 : answerQuestionIds.size();

                    //选则题
                    if (trResearchQuestion.getType() == 1 || trResearchQuestion.getType() == 2) {
                        row.createCell(1).setCellValue("有效填写:" + valid);
                        row = sheet.createRow((int) index);
                        row.createCell(0).setCellValue("选项");
                        row.createCell(1).setCellValue("小计");
                        row.createCell(2).setCellValue("比例");
                        index++;//行索引


                        List<TrResearchQuestionOption> optionList = questionOptionMap.get(questionId);
                        if (CollectionUtils.isNotEmpty(optionList)) {
                            for (TrResearchQuestionOption option : optionList) {
                                row = sheet.createRow((int) index);
                                //填写选项内容
                                row.createCell(0).setCellValue(option.getContent());
                                index++;

                                //获取单选题类型该问题 答题了的选项总数
                                Integer totalCount1 = 0;
                                //获取多选题选题类型该问题 答题了的选项总数
                                Integer totalCount2 = 0;
                                //每个选项被选了的数目
                                Integer checkCount = 0;

                                if (CollectionUtils.isNotEmpty(answerQuestionIds)) {
                                    for (Long a : answerQuestionIds) {
                                        List<TrResearchAnswerQuestionResult> results = answerResultMap.get(a);
                                        if (CollectionUtils.isNotEmpty(results)) {
                                            for (TrResearchAnswerQuestionResult result : results) {
                                                Integer type = result.getQuestionType();
                                                if (type == 1 && result.getOptionId() != null) {
                                                    ++totalCount1;
                                                } else if (type == 2 && result.getOptionId() != null) {
                                                    ++totalCount2;
                                                }
                                                if (type == 1 || type == 2) {
                                                    if (option.getId().equals(result.getOptionId())) {
                                                        ++checkCount;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }

                                //填写小计数据
                                row.createCell(1).setCellValue(checkCount);

                                //填写比例值
                                cell = row.createCell(2);
                                if (checkCount == 0) {
                                    cell.setCellValue("0%");
                                } else {
                                    BigDecimal checkNum = new BigDecimal(checkCount);
                                    BigDecimal totalNum = new BigDecimal(1);
                                    if (trResearchQuestion.getType() == 1) {
                                        totalNum = new BigDecimal(totalCount1);
                                    } else if (trResearchQuestion.getType() == 2) {
                                        totalNum = new BigDecimal(totalCount2);
                                    }
                                    BigDecimal tem = new BigDecimal(100);
                                    cell.setCellValue((checkNum.multiply(tem).divide(totalNum, 2, ROUND_HALF_DOWN)) + "%");
                                }
                            }
                        }
                        //问答题
                    } else if (trResearchQuestion.getType() == 3) {
                        for (ResearchGroupViewVo groupViewVo : researchGroupViewVos) {
                            row = sheet.createRow((int) index);
                            index++;

                            //填写答题人的用户名
                            String accountName = groupViewVo.getAccountName();
                            row.createCell(0).setCellValue(accountName == null ? "" : accountName);

                            //填写完成时间
                            Date date = groupViewVo.getFinishTime();
                            row.createCell(1).setCellValue(sdf1.format(date == null ? 0 : date));

                            //填写回答内容
                            if (CollectionUtils.isNotEmpty(answerQuestionIds)) {
                                TrResearchAnswerQuestion tem = new TrResearchAnswerQuestion();
                                tem.setAccountId(groupViewVo.getAccountId());
                                tem.setQuestionId(questionId);
                                tem.setResearchId(researchId);
                                tem = this.trResearchAnswerQuestionService.selectOne(new EntityWrapper<>(tem));
                                if (tem != null) {
                                    List<TrResearchAnswerQuestionResult> results = answerResultMap.get(tem.getId());
                                    TrResearchAnswerQuestionResult result = results.get(0);
                                    String content = result.getContent();
                                    row.createCell(2).setCellValue(content == null ? "" : content);
                                }
                            }
                        }
                    } else {
                        //打分题
                        row.createCell(1).setCellValue("有效填写:" + valid);
                        row = sheet.createRow((int) index);
                        index++;
                        row.createCell(0).setCellValue("打分项");
                        row.createCell(1).setCellValue("10");
                        row.createCell(2).setCellValue("9");
                        row.createCell(3).setCellValue("8");
                        row.createCell(4).setCellValue("7");
                        row.createCell(5).setCellValue("6");
                        row.createCell(6).setCellValue("5");
                        row.createCell(7).setCellValue("4");
                        row.createCell(8).setCellValue("3");
                        row.createCell(9).setCellValue("2");
                        row.createCell(10).setCellValue("1");
                        row.createCell(11).setCellValue("0");
                        row.createCell(12).setCellValue("参与人数");
                        row.createCell(13).setCellValue("最高分");
                        row.createCell(14).setCellValue("最低分");
                        row.createCell(15).setCellValue("总分");
                        row.createCell(16).setCellValue("平均分");
                        //取出该问题的选项集合
                        List<TrResearchQuestionOption> options = questionOptionMap.get(questionId);
                        if (options == null) {
                            continue;
                        }
                        for (TrResearchQuestionOption option : options) {
                            row = sheet.createRow(index);
                            index++;

                            //填写选项内容
                            row.createCell(0).setCellValue(option.getContent() == null ? "" : option.getContent());

                            List<Long> answerQuestionIds1 = answerQuestionMap.get(questionId);
                            if (answerQuestionIds1 == null) {
                                continue;
                            }
                            Integer joinNum = 0;
                            Integer maxScore = 0;
                            Integer minScore = 0;
                            Integer totalScore = 0;
                            String avgScore = "";
                            //计数
                            Integer num = 1;
                            //以分数为key,选择人数为value
                            Map<Integer, Integer> scoreMap = new HashMap<>();

                            for (Long id : answerQuestionIds1) {
                                List<TrResearchAnswerQuestionResult> results = answerResultMap.get(id);
                                if (results == null) {
                                    continue;
                                }
                                for (TrResearchAnswerQuestionResult result : results) {
                                    if (result.getQuestionType() == 4) {
                                        if (result.getOptionId().equals(option.getId())) {
                                            Integer score = result.getScore();
                                            joinNum = num;
                                            totalScore = totalScore + score;

                                            BigDecimal a = new BigDecimal(totalScore);
                                            BigDecimal c = new BigDecimal(joinNum);
                                            avgScore = a.divide(c, 2, ROUND_HALF_DOWN).toString();
                                            BigDecimal avg = new BigDecimal(avgScore);
                                            if (score > maxScore) {
                                                maxScore = score;
                                            }
                                            if (score < minScore) {
                                                minScore = score;
                                            }
                                            num++;
                                            if (!scoreMap.containsKey(score)) {
                                                scoreMap.put(score, 1);
                                            } else {
                                                Integer tem = scoreMap.get(score);
                                                scoreMap.put(score, (tem + 1));
                                            }
                                        }
                                    }
                                }
                            }
                            Integer tem = 10;
                            for (; tem >= 0; tem--) {
                                //获取选择了该分数的参与人数
                                Integer theOptionJoinNum = scoreMap.get(tem);
                                if (theOptionJoinNum == null) {
                                    continue;
                                }
                                //获取该分数的位置
                                Integer scoreIndex = scoreIndexMap.get(tem);
                                //填写选择了该分数的人数
                                row.createCell(scoreIndex).setCellValue(theOptionJoinNum);
                            }
                            //填写参与人数
                            row.createCell(12).setCellValue(joinNum);
                            //填写最高分
                            row.createCell(13).setCellValue(maxScore);
                            //填写最低分
                            row.createCell(14).setCellValue(minScore);
                            //填写总分
                            row.createCell(15).setCellValue(totalScore);
                            //填写平均分
                            row.createCell(16).setCellValue(avgScore);
                        }
                    }
                }
            }


            //导出

            StringBuffer fileNameSb = new StringBuffer().append(vo.getTaskName()).append(".xlsx");
            String fileName = fileNameSb.toString();
            String path = new StringBuffer().append(requestPath).append(fileNameSb).toString();
            FileOutputStream os = null;
            File file = null;
            try {
                os = new FileOutputStream(path);
                workbook.write(os);
                //阿里云返回url
                upLoadUrl = OssUpload.upload(path, fileName);
                file = new File(path);
                success(taskContext, "成功", upLoadUrl);
            } catch (Exception e1) {
                e1.printStackTrace();
                fail(taskContext, "写入过程中发生错误");
                logger.error("写入数据到Excel的过程中或者上传到阿里云中发生错误");
            } finally {
                if (os != null) {
                    os.close();
                }
                if (workbook != null) {
                    workbook.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
        } catch (
                Exception e) {
            e.printStackTrace();
            fail(taskContext, researchName + "导出过程中发生错误，请查看日志");
            logger.error("创建Excel的过程中发生错误");
        }
        System.out.println("系统运行啦" + (System.currentTimeMillis() - s12));
        return upLoadUrl;
    }

    private Integer queryCanJoinNum(Long researchId, RequestContext context) {


        Integer canJoinNum = 0;
        //"可见范围，1平台用户可见（企业下所有人员） 2指定学员可见"
        Integer visibRange = researchService.selectById(researchId).getVisibleRange();

        List<Long> accountIds = new ArrayList<>();
        List<Long> orgIds = new ArrayList<>();

        // 如果是调研指定范围
        if (visibRange == 2) {
            TrResearchAuthorize example = new TrResearchAuthorize();
            example.setResearchId(researchId);
            List<TrResearchAuthorize> authorizes = example.selectList(new EntityWrapper(example));
            if (CollectionUtils.isNotEmpty(authorizes)) {
                for (TrResearchAuthorize authorize : authorizes) {
                    if (authorize.getType().equals(1)) {
                        orgIds.add(authorize.getRelationId());
                    } else {
                        accountIds.add(authorize.getRelationId());
                    }
                }
                //获取调研可见范围内的用户数据
                List<ReportAccountRespVO> queryAccountList = queryConditionalAccount(context, orgIds, accountIds);
                List<Long> accountIdList = new ArrayList<>();
                //获取全平台或者管辖区人员数据
                List<ReportAccountRespVO> manageAccountList = queryAccountList(context, orgIds, accountIds);

                if (CollectionUtils.isNotEmpty(queryAccountList)) {
                    if (CollectionUtils.isNotEmpty(manageAccountList)) {
                        for (ReportAccountRespVO vo : queryAccountList) {
                            for (ReportAccountRespVO manageVo : manageAccountList) {
                                if (manageVo.equals(vo.getUserId())) {
                                    accountIdList.add(vo.getUserId());
                                }
                            }
                        }
                        canJoinNum = accountIdList.size();
                    }
                }
            }

        } else {

            //获取全平台或者管辖区人员数据   orgids,accountIds 都是空的
            List<ReportAccountRespVO> queryAccountList = queryAccountList(context, orgIds, accountIds);
            canJoinNum = queryAccountList.size();
        }
        return canJoinNum;
    }

    private List<ResearchGroupViewVo> fillGroupViewVo(List<ResearchGroupViewVo> researchGroupViewVos) {

        List<Long> accountIds = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(researchGroupViewVos)) {
            for (ResearchGroupViewVo groupViewVo : researchGroupViewVos) {
                accountIds.add(groupViewVo.getAccountId());
            }
            List<AccountVO> accountVOs = accountClient.idsGet(accountIds);
            //获取 《accountId,name》Map集合
            Map<Long, String> accountMap = new HashMap<>();
            //实时取用户名
            accountVOs.forEach(accountVo -> {
                if (!accountMap.containsKey(accountVo.getId())) {
                    accountMap.put(accountVo.getId(), accountVo.getName());
                }
            });

            for (ResearchGroupViewVo groupViewVo : researchGroupViewVos) {
                groupViewVo.setAccountName(accountMap.get(groupViewVo.getAccountId()));
            }

            return researchGroupViewVos;
        }

        return new ArrayList<>();
    }


    //获取全平台或者管辖区人员数据
    private List<ReportAccountRespVO> queryAccountList(RequestContext context, List<Long> orgIds, List<Long> accountIds) {

        List<ReportAccountRespVO> queryAccountList = new ArrayList<>();

        if (context.isAdmin()) {
            //全平台的用户数据
            queryAccountList = queryConditionalAccount(context, new ArrayList<>(), new ArrayList<>());
        } else {
            HQAccountInManageParam hp = new HQAccountInManageParam();
            hp.setAccountId(context.getAccountId());
            hp.setSiteId(context.getSiteId());
            hp.setModuleType(AuthzConstant.moduleType.statistics_research);
            ReportAccountRespInManageVO vo = reportClient.getRangeAccountsInManage(hp);
            queryAccountList = vo.getList();
            if (CollectionUtils.isEmpty(queryAccountList)) {
                queryAccountList = new ArrayList<>();
            }
        }

        return queryAccountList;
    }

    //查询指定范围内的人
    private List<ReportAccountRespVO> queryConditionalAccount(RequestContext context, List<Long> orgIds, List<Long> accountIds) {
        ReportRangeAccountReqVO rrarv = new ReportRangeAccountReqVO();
        rrarv.setSiteId(context.getSiteId());
        rrarv.setOrgIds(orgIds);
        rrarv.setAccountIds(accountIds);
        List<ReportAccountRespVO> queryAccountList = reportClient.getRangeAccounts(rrarv);
        if (CollectionUtils.isEmpty(queryAccountList)) {
            queryAccountList = new ArrayList<>();
        }
        return queryAccountList;
    }
}

