package com.yizhi.research.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;

import com.yizhi.research.application.vo.domain.TrResearchAuthorize;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 调研用户范围 Mapper 接口
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
public interface TrResearchAuthorizeMapper extends BaseMapper<TrResearchAuthorize> {

    /**
     * 查询指定范围内的可见调研id
     *
     * @param relationIds
     * @return
     */
    List<Long> getResearchIdsInRange(@Param("relationIds") List<Long> relationIds);
    
    int batchInsert(@Param("list") List<TrResearchAuthorize> researchAuthorizes);
    
    void deleteByResearchId(@Param("researchId") Long researchId);


    List<Long> getUsefulIds(@Param("ids") List<Long> ids,@Param("relationIds") List<Long> relationIds,@Param("siteId") Long siteId);
}
