package com.yizhi.research.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.research.application.vo.domain.TrResearchQuestion;
import com.yizhi.research.application.vo.domain.VoteRankingVo;

import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 问题 Mapper 接口
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
public interface TrResearchQuestionMapper extends BaseMapper<TrResearchQuestion> {

    /**
     * 批量插入问题
     *
     * @param questions
     * @return
     */
    int batchInsert(@Param("list") List<TrResearchQuestion> questions);

    /**
     * 批量删除
     *
     * @param researchIds 所属调研id
     * @return
     */
    int batchDeleteByResearchId(@Param("ids") List<Long> researchIds);

    /**
     * 批量删除
     *
     * @param ids 主键id
     * @return
     */
    int batchDeleteById(@Param("ids") List<Long> ids);

    /**
     * 通过id跟新序号
     *
     * @return
     */
    int updateNoById(@Param("id") Long id, @Param("jumpNo") Integer jumpNo);

    int updateNo(@Param("id") Long id, @Param("jumpNo") Integer jumpNo);

    int updateQNoById(@Param("id") Long id, @Param("no") Integer no);

    /**
     * 选择跳题时的问题列表
     *
     * @param no
     * @param researchId
     * @return
     */
    List<TrResearchQuestion> listAllForJump(@Param("no") Integer no, @Param("researchId") Long researchId);

    /*@Update("update tr_research_question set jump_type = #{type} " +
            "<if test = 'jumpNo != null'>and jump_num = #{jumpNo} </if>" +
            "and and update_by_id = #{upDateById} and update_by_name = #{upDateByName} and " +
            "update_time = #{upDateTime} where id = #{questionId}")
    int updateQuestionJump(
            @Param("type") Integer type,@Param("jumpNo") Integer jumpNo,@Param("questionId") Long id,
            @Param("upDateById") Long upDateById, @Param("upDateByName")String upDateByName,
            @Param("upDateTime")Date upDateTime);*/

    @Select("select no from tr_research_question where id = (select question_id from " +
            "tr_research_question_option where id = #{optionId})")
    Integer selectByOptionId(@Param("optionId") Long optionId);

    @Select("select * from tr_research_question where no = #{oldLastNo} and research_id = #{researchId}")
    TrResearchQuestion selectOneByNo(@Param("oldLastNo") Integer oldLastNo, @Param("researchId") Long researchId);

    List<Long> getFinishedAccountIds(@Param("researchId") Long researchId, @Param("companyId") Long companyId, @Param("siteId") Long siteId);

    /* List<Long> selectQuestion(@Param("startNo") Integer startNo,@Param("endNo") Integer endNo,@Param("researchId") Long researchId);*/
    @Update("update tr_research_question set no = no-1 where id in " +
            "(<foreach collection=\"accountIds\" item=\"accountId\" index=\"index\" open=\"(\" close=\")\" separator=\",\">\n" +
            "                #{accountId}\n" +
            "            </foreach>)")
    void updateNos(@Param("ids") Set<Long> ids);

    void updateJumpNum(@Param("ids") List<Long> ids);

    /**
     * 获取投票结果
     * @param companyId
     * @param siteId
     * @param researchId
     * @param accountId
     * @return
     */
	VoteRankingVo getVoteResult(@Param("companyId") Long companyId, @Param("siteId") Long siteId,
                                @Param("researchId") Long researchId, @Param("accountId") Long accountId,
                                @Param("pageStart") Integer pageStart,@Param("pageEnd") Integer pageEnd);

    /**
     * 投票排行榜
     * @param companyId
     * @param siteId
     * @param researchId
     * @return
     */
    VoteRankingVo getVoteTop(@Param("companyId") Long companyId, @Param("siteId") Long siteId,
                             @Param("researchId") Long researchId);

    /**
     * 刪除投票中的指定問題
     * @param id
     * @param researchId
     * @return
     */
    int deleteByResearchIdAndQueId(@Param("id") Long id, @Param("researchId") Long researchId);
}
