package com.yizhi.research.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.research.application.vo.domain.TrResearchQuestionOption;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 只对题型是：单选题、多选题和打分题 Mapper 接口
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
public interface TrResearchQuestionOptionMapper extends BaseMapper<TrResearchQuestionOption> {

    /**
     * 批量插入问题项
     *
     * @param questions
     * @return
     */
    int batchInsert(@Param("list") List<TrResearchQuestionOption> questions);

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    int batchDelete(@Param("ids") List<Long> ids, @Param("updateTime") Date updateTime, @Param("updateById") Long updateById, @Param("updateByName") String updateByName);

    /**
     * 查询问题选项
     *
     * @param questionId
     * @return
     */
    @Select("select * from tr_research_question_option where question_id = #{questionId} and deleted = 0 order by no asc")
    List<TrResearchQuestionOption> listAllByQuestionId(@Param("questionId") Long questionId);

    @Select("select * from tr_research_question_option where research_id = #{researchId} and deleted = 0")
    List<TrResearchQuestionOption> listAllByResearchId(@Param("researchId") Long libraryId);

    @Select("select * from tr_research_question_option where id in (select option_id from tr_research_answer_question_result" +
            " where answer_id = #{answerId})")
    List<TrResearchQuestionOption> selectByAnswer(Long answerId);

    void updateJumpNum(@Param("ids") List<Long> ids);

    /**
     * 刪除投票中的指定選項
     * @param queId
     * @param researchId
     * @return
     */
    int deleteByResearchIdAndQueId(@Param("queId") Long queId, @Param("researchId") Long researchId);
}
