package com.yizhi.research.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.research.application.vo.BaseModel;
import com.yizhi.research.application.vo.VisibleRangeExport;
import com.yizhi.research.application.vo.api.PageVo;
import com.yizhi.research.application.vo.domain.Research;
import com.yizhi.research.application.vo.domain.ResearchVo;

import io.swagger.annotations.ApiParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 调研 服务类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
public interface IResearchService extends IService<Research> {

    /**
     * 保存 Research 实体
     *
     * @return
     */
    Research insertResearch(Research research);

    /**
     * 列表分页
     *
     * @param page
     * @return
     */
    Page<Research> listPage(Map map, RequestContext requestContext, Integer pageNo, Integer pageSize);

    /**
     * 批量删除（仅能删除草稿状态）
     * 连带删除 调研问题，调研问题选项
     *
     * @param ids id集合
     * @return
     */
    int batchDelete(List<Long> ids);

    /**
     * 更新调研
     *
     * @param research
     * @return
     */
    int update(Research research);

    /**
     * 查询一个
     * 组装reminds
     *
     * @param id
     * @return
     */
    Research viewOne(Long id);

    /**
     * 发布调研，并返回
     *
     * @param research
     * @return
     */
    Research upOrDown(Research research) throws Exception;

    /**
     * 复制调研
     *
     * @param id
     * @return
     */
    Research copyResearch(Long id, RequestContext context, Date date) throws Exception;

    // ********************************学员端接口*****************************************

    /**
     * 学员端调研列表
     *
     * @param accountId
     * @param date
     * @param state     1 已完成，2 进行中
     * @param pageNo
     * @param pageSize
     * @return
     */
//    Page<Research> apiListPage(Long accountId, Date date, Integer state, int pageNo, int pageSize);
    Page<Research> apiListPage(BaseModel<PageVo> model);

    /**
     * 分页模糊查询
     *
     * @param context
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<Research> apiSearchPage(String name, RequestContext context, int pageNo, int pageSize);
    
    /**
     * 查询我的调研进行中的个数
     */
    Integer searchUnfinishCount(RequestContext context);
    /**
     * 检查学员某个调研的状态
     */
    Integer checkResearchState(Long researchId,RequestContext context);

    /**
     * 检查某个活动中某个调研状态
     * @param researchId
     * @param context
     * @return
     */
    Integer checkTPlanResearchState(Long researchId, RequestContext context);

    Page<Research> getResearchList(String startDate, String endDate, String kwd,Integer pageSize, Integer pageNo,List<Long> orgIds, Long companyId, Long siteId);

    Research getResearchView(Long researchId);
    
    
    /**
	 * 范围人员导出             管理端-------2018/09/19
	 * @param assignmentId
	 * @return
	 */
	public VisibleRangeExport vsibleRangeExport(Long researchId);

    Page<Map<String, Object>> getPoolExamList(String name, List<Long> ids, Integer pageNo, Integer pageSize);
    
    List<Map<String, Object>> getServerByCompanyIdAndIds(Long companyId,List<Long> ids);

    Page<Research> getPageToCalendar(Date date, Page<Research> page);

    Page<DroolsVo> getPageByDrools(String field, String value, Page<DroolsVo> page);

    /**
     * 查看调研信息
     * @param id
     * @return
     */
    Research viewInfo(Long id);

    /**
     * 获取置顶的调研信息
     * @param bizType
     * @return
     */
	List<ResearchVo> getResearchTop(Integer bizType);

	/**
	 * 查看调研详情
	 * @param id
	 * @return
	 */
	ResearchVo getResearchDetails(Long id);
	
	/**
	 * 滚动提示接口：投票管理（4天内创建且已上架的数据）
	 * @param model
	 * @return
	 */
	List<Research> apiVoteManagementForScroll(BaseModel<PageVo> model);
}
