package com.yizhi.research.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.research.application.model.AnswerModel;
import com.yizhi.research.application.vo.api.ViewAnswerVo;
import com.yizhi.research.application.vo.domain.TrResearchAnswer;

import java.util.List;

/**
 * <p>
 * 答卷 服务类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
public interface ITrResearchAnswerService extends IService<TrResearchAnswer> {

    /**
     * 学员提交答案
     *
     * @param answerModel
     * @return
     */
    int submitAnswer(AnswerModel answerModel) throws Exception;

    /**
     * 学员端查看问卷答案
     *
     * @param researchId
     * @param accountId
     * @return
     */
    ViewAnswerVo apiViewAnswer(Long researchId, Long accountId);

    Page<ViewAnswerVo> apiViewAnswers(Long researchId, Integer pageNo, Integer pageSize);

    List<ViewAnswerVo> viewList(Long researchId);

    Integer apiViewAnswersCount(Long researchId);

    List<ViewAnswerVo> viewAnswerVoList(Long researchId,Integer pageNo,Integer pageSize);

}
