package com.yizhi.research.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.research.application.model.ModifyQuestionModel;
import com.yizhi.research.application.vo.api.MyQuestion;
import com.yizhi.research.application.vo.api.QuestionJumpVo;
import com.yizhi.research.application.vo.domain.TrResearchQuestion;
import com.yizhi.research.application.vo.domain.VoteRankingVo;

import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 问题 服务类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
public interface ITrResearchQuestionService extends IService<TrResearchQuestion> {

    /**
     * 批量插入问题 （包含问题选项）
     *
     * @param researchQuestions
     * @return
     */
    int batchInsert(List<TrResearchQuestion> researchQuestions);

    /**
     * 更新问题
     *
     * @param modifyQuestionModel
     * @return
     */
    int batchUpdate(ModifyQuestionModel modifyQuestionModel) throws Exception;


    int updateNo(QuestionJumpVo vo);

    /**
     * 分页查询调研问题
     *
     * @param map
     * @return
     */
    List<TrResearchQuestion> listPage(Map<String, Object> map);

    /**
     * 查询所有的
     *
     * @param researchId 所属调研id
     * @return
     */
    List<TrResearchQuestion> listAll(Long researchId);

    /**
     * 选择跳题时的问题列表
     *
     * @param questionId 需要跳题的问题id
     * @return
     */
    List<TrResearchQuestion> listAllForJump(Long questionId);


    MyQuestion lastAndNext(MyQuestion myQuestion);

    /**
     * 修改问题跳题规则
     * @param vo
     * @return
     */
    Integer updateQuestionJump(QuestionJumpVo vo);

    List<Long> getFinishedAccountIds(Long researchId, Long companyId, Long siteId);

    /**
     * 获取投票结果
     * @param researchId
     * @return
     */
	VoteRankingVo getVoteResult(Long researchId, Integer pageNo, Integer pageSize);

	/**
     * 获取投票排行榜
     * 按投票票数升序、票数相同时按谁先被投票的
     * @param researchId
     * @return
     */
	VoteRankingVo getVoteTop(Long researchId);

    /**
     * 刪除投票中的問題
     * @param queId
     * @param researchId
     */
    int deleteByResearchIdAndQueId(Long queId, Long researchId);
}
