package com.yizhi.research.application.service.impl;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;


import com.alibaba.fastjson.JSON;
import com.yizhi.application.orm.hierarchicalauthorization.HQueryUtil;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.TaskParamsEnums;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.research.application.ResearchConstant;
import com.yizhi.research.application.eum.ResearchState;
import com.yizhi.research.application.model.DataRangeModel;
import com.yizhi.research.application.util.ResearchEvenSendMessage;
import com.yizhi.research.application.mapper.*;
import com.yizhi.research.application.service.IResearchService;
import com.yizhi.research.application.service.ITrResearchAuthorizeService;
import com.yizhi.research.application.vo.BaseModel;
import com.yizhi.research.application.vo.MessageRemindVo;
import com.yizhi.research.application.vo.VisibleRangeExport;
import com.yizhi.research.application.vo.api.PageVo;
import com.yizhi.research.application.vo.domain.*;
import com.yizhi.util.application.clazz.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import org.apache.ibatis.session.RowBounds;

/**
 * <p>
 * 调研 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Service
@Transactional
public class ResearchServiceImpl extends ServiceImpl<ResearchMapper, Research> implements IResearchService {

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private ResearchMapper researchMapper;
    @Autowired
    private TrResearchRemindMapper researchRemindMapper;
    @Autowired
    private TrResearchQuestionMapper researchQuestionMapper;
    @Autowired
    private TrResearchQuestionOptionMapper researchQuestionOptionMapper;
    @Autowired
    private TrResearchAuthorizeMapper researchAuthorizeMapper;
    @Autowired
    private TrResearchAnswerMapper researchAnswerMapper;
    @Autowired
    private TrResearchAuthorizeMapper trResearchAuthorizeMapper;
    @Autowired
    private ITrResearchAuthorizeService researchAuthorizeService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ResearchEvenSendMessage researchEvenSendMessage;

    private final static Logger LOG =  LoggerFactory.getLogger(ResearchServiceImpl.class);


    @Override
    public Research insertResearch(Research research) {
        research.setId(idGenerator.generate());
        research.setResearchNo(getResearchNo(research.getSiteId()));
        int num = researchMapper.insert(research);
        RequestContext context = ContextHolder.get();

        //设置关联人员
        List<TrResearchAuthorize> researchAuthorizes = research.getAuthorizes();
        if (!CollectionUtils.isEmpty(researchAuthorizes)) {
            for (TrResearchAuthorize authorize : researchAuthorizes) {
                authorize.setId(idGenerator.generate());
                authorize.setResearchId(research.getId());
            }
            researchAuthorizeMapper.batchInsert(researchAuthorizes);
        }

        LOG.info("是否开启提醒：" + research.getRemind());
        LOG.info("参数：" + JSON.toJSONString(research));
        if (num == 1 && research.getRemind() == 1) {
            // 设置提醒
            try {
                //发消息告知提醒有变化
                taskExecutor.asynExecute(new AbstractTaskHandler() {
                    @Override
                    public void handle() {
                        researchEvenSendMessage.systemSendMessage(research, research.getMessageRemindVo(), context);
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if(!CollectionUtils.isEmpty(research.getReminds())){
            research.getReminds().stream().forEach(r->{
                r.setResearchId(research.getId());
            });
            researchRemindMapper.batchInsert(research.getReminds());
        }
        return research;
    }


    @Override
    public Page<Research> listPage(Map map, RequestContext context, Integer pageNo, Integer pageSize) {
        HQueryUtil.startHQ(Research.class);
        Integer state = null;
        String name = null;
        Integer bizType = null;

        if (!StringUtils.isEmpty(map.get("state"))) {
            state = (Integer) map.get("state");
        }
        if (!StringUtils.isEmpty(map.get("name"))) {
            name = (String) map.get("name");
        }
        if (!StringUtils.isEmpty(map.get("bizType"))) {
            bizType = (Integer) map.get("bizType");
        }
        //为过滤过期调研准备
        String date=null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if(null!=map.get("currentTime")){
            date = map.get("currentTime").toString();
            Long s =Long.valueOf(date);
            date = simpleDateFormat.format(s);
        }



        // 数据隔离
        DataRangeModel dataRangeModel = new DataRangeModel();
        dataRangeModel.setSiteId(context.getSiteId());
        if (context.isAdmin()) {
            dataRangeModel.setAdmin(true);
        } else {
            dataRangeModel.setAdmin(false);
            dataRangeModel.setOrgIds(context.getOrgIds());
        }

        Page<Research> page = new Page<>(pageNo, pageSize);
        page.setTotal(researchMapper.listPageCount(date,state, name, bizType, dataRangeModel));
        page.setRecords(researchMapper.listPage(date,state, name, bizType, dataRangeModel, new RowBounds(page.getOffset(), page.getLimit())));

        return page;
    }

    @Override
    public int batchDelete(List<Long> ids) {

        int num = researchMapper.batchDelete(ids);
        if (num != ids.size()) {
            throw new RuntimeException("处理异常：调研 删除数目 与 传入调研id集合长度对不上，事务回滚！！");
        }

        researchQuestionMapper.batchDeleteByResearchId(ids);
        researchQuestionOptionMapper.batchDelete(ids, null, null, null);

        return num;
    }

    @Override
    public int update(Research research) {
        int num = 0;
        try {
            num = researchMapper.updateById(research);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (num != 1) {
            throw new RuntimeException("处理异常：调研 更新失败，事务回滚！！");
        }
        //更新关联人员
        List<TrResearchAuthorize> authorizes = research.getAuthorizes();
        if (!CollectionUtils.isEmpty(authorizes)) {
            researchAuthorizeMapper.deleteByResearchId(research.getId());
            for (TrResearchAuthorize authorize : authorizes) {
                authorize.setId(idGenerator.generate());
                authorize.setResearchId(research.getId());
            }
            researchAuthorizeMapper.batchInsert(authorizes);
        }
        LOG.info("是否开启提醒：" + research.getRemind());
        RequestContext context = ContextHolder.get();
        if (num > 0) {
            Research  research1 = this.selectById(research.getId());
            // 设置提醒
            try {
                //发消息告知提醒有变化
                taskExecutor.asynExecute(new AbstractTaskHandler() {
                    @Override
                    public void handle() {
                        researchEvenSendMessage.systemSendMessage(research1, research.getMessageRemindVo(),context);
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        researchRemindMapper.deleteByResearchId(research.getId());
        if(!CollectionUtils.isEmpty(research.getReminds())){
            research.getReminds().stream().forEach(r->{
                r.setResearchId(research.getId());
            });
            researchRemindMapper.batchInsert(research.getReminds());
        }
        return num;
    }

    @Override
    public Research viewOne(Long id) {
        Research research = researchMapper.selectById(id);
        if (research != null) {
            // 查出调研提醒
            if (research.getRemind() == 1 || research.getEnableAppRemind() == 1 || research.getEnableMailRemind() == 1) {
                TrResearchRemind trResearchRemind = new TrResearchRemind();
                trResearchRemind.setResearchId(id);
                trResearchRemind.setDeleted(0);
                research.setReminds(researchRemindMapper.selectList(new EntityWrapper<TrResearchRemind>(trResearchRemind)));
            }
            //查看关联人员
            TrResearchAuthorize authorize = new TrResearchAuthorize();
            authorize.setResearchId(id);
            research.setAuthorizes(researchAuthorizeMapper.selectList(new EntityWrapper<TrResearchAuthorize>(authorize)));
        }
        return research;
    }


    @Override
    public Research upOrDown(Research research) throws Exception {
        // 如果是上架，需要判断是否有题目
        if (research.getState().equals(ResearchState.RELEASED.getValue())) {
            TrResearchQuestion question = new TrResearchQuestion();
            question.setResearchId(research.getId());
            question.setDeleted(0);

            if (researchQuestionMapper.selectCount(new EntityWrapper<>(question)) < 1) {
                throw new Exception("该调研下没有创建题目，上架失败！");
            }
        }
        if (researchMapper.updateById(research) > 0) {
            research = this.selectById(research.getId());
            RequestContext context = ContextHolder.get();
            if (research.getRemind() == 1){
                try {
                    //发消息告知业务状态有变化
                    MessageRemindVo remindVo = new MessageRemindVo();
                    remindVo.setTaskStatusUpdate(true);
                    Research finalResearch = research;
                    taskExecutor.asynExecute(new AbstractTaskHandler() {
                        @Override
                        public void handle() {
                            researchEvenSendMessage.systemSendMessage(finalResearch,remindVo, context);
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return researchMapper.selectById(research.getId());
    }
    @Transactional
    @Override
    public Research copyResearch(Long id, RequestContext context, Date date) throws Exception {
        // 查询之前的
        Research origResearch = researchMapper.selectStateOne(id);

        TrResearchQuestion questionExample = new TrResearchQuestion();
        questionExample.setDeleted(0);
        questionExample.setResearchId(id);
        List<TrResearchQuestion> origQuestions = researchQuestionMapper.selectList(new EntityWrapper<TrResearchQuestion>(questionExample));

        TrResearchQuestionOption optionExample = new TrResearchQuestionOption();
        optionExample.setDeleted(0);
        optionExample.setResearchId(id);
        List<TrResearchQuestionOption> origOptions = researchQuestionOptionMapper.selectList(new EntityWrapper<TrResearchQuestionOption>(optionExample));

        if (null == origResearch) {
            throw new Exception("id: " + id + " 的调研不存在！！");
        }

        origResearch.setId(idGenerator.generate());
        origResearch.setName(origResearch.getName() + "【复制件】");
//        origResearch.setRemind(null);
        origResearch.setUnReleaseTime(null);
        origResearch.setUnReleaseByName(null);
        origResearch.setUnReleaseById(null);
        origResearch.setEnableMailRemind(null);
        origResearch.setEnableAppRemind(null);
        origResearch.setState(ResearchState.GRAFT.getValue());
        origResearch.setReleaseById(null);
        origResearch.setReleaseByName(null);
        origResearch.setReleaseTime(null);
        origResearch.setSiteId(context.getSiteId());
        origResearch.setCompanyId(context.getCompanyId());
        origResearch.setOrgId(context.getOrgId());
        origResearch.setResearchNo(getResearchNo(context.getSiteId()));
        //      origResearch.setVisibleRange(null);
//        origResearch.setStartTime(null);
//        origResearch.setEndTime(null);
        origResearch.setCreateByName(context.getAccountName());
        origResearch.setCreateById(context.getAccountId());
        origResearch.setCreateTime(date);
        origResearch.setUpdateTime(null);
        origResearch.setUpdateByName(null);
        origResearch.setUpdateById(null);

        //复制人员

        Long oldId;
        TrResearchAuthorize authorize = new TrResearchAuthorize();
        authorize.setResearchId(id);
        List<TrResearchAuthorize> authorizes = null;
        try{
            authorizes = trResearchAuthorizeMapper.selectList(new EntityWrapper<>(authorize));
            if(!CollectionUtils.isEmpty(authorizes)) {
                for (TrResearchAuthorize researchAuthorize : authorizes) {
                    researchAuthorize.setId(idGenerator.generate());
                    researchAuthorize.setResearchId(origResearch.getId());
                    researchAuthorize.setCreateById(context.getAccountId());
                    researchAuthorize.setCreateByName(context.getAccountName());
                    researchAuthorize.setCreateTime(date);
                    researchAuthorize.setSiteId(context.getSiteId());
                    researchAuthorize.setUpdateByName(null);
                    researchAuthorize.setUpdateById(null);
                    researchAuthorize.setUpdateTime(null);
                }
                researchAuthorizeMapper.batchInsert(authorizes);
            }
        }catch (Exception e){
            e.printStackTrace();
            LOG.error("赋值人员出错-------",e);
        }


        // 将之前的id对应起来，方便下面组装问题选项
        Map<Long, Long> origNowQuestionIdMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(origQuestions)) {
            Long nowId = null;
            for (TrResearchQuestion question : origQuestions) {
                nowId = idGenerator.generate();
                // 将之前的id对应起来，方便下面组装问题选项
                origNowQuestionIdMap.put(question.getId(), nowId);
                question.setId(nowId);
                question.setSiteId(context.getSiteId());
                question.setCompanyId(context.getCompanyId());
                question.setOrgId(context.getOrgId());
                question.setCreateByName(context.getAccountName());
                question.setCreateTime(date);
                question.setCreateById(context.getAccountId());
                question.setResearchId(origResearch.getId());
                question.setUpdateByName(null);
                question.setUpdateById(null);
                question.setUpdateTime(null);
            }
            researchQuestionMapper.batchInsert(origQuestions);
        }
        if (!CollectionUtils.isEmpty(origOptions)) {
            for (TrResearchQuestionOption option : origOptions) {
                option.setQuestionId(origNowQuestionIdMap.get(option.getQuestionId()));
                option.setResearchId(origResearch.getId());
                option.setCreateTime(date);
                option.setCreateByName(context.getAccountName());
                option.setCreateById(context.getAccountId());
                option.setUpdateByName(null);
                option.setUpdateTime(null);
                option.setUpdateById(null);
                option.setId(idGenerator.generate());
            }
            researchQuestionOptionMapper.batchInsert(origOptions);
        }

//        if (researchMapper.insert(origResearch) > 0) {
//            LOG.info("是否开启提醒：" + origResearch.getRemind());
//            if (origResearch.getRemind() == 1) {
//                // 设置提醒
//                try {
//                    MessageRemindVo vo = new MessageRemindVo();
//                    vo.setIsCopy(true);
//                    vo.setOldRelationId(id);
//
//                    //发消息告知提醒有变化
//                    taskExecutor.asynExecute(new AbstractTaskHandler() {
//                        @Override
//                        public void handle() {
//                            researchEvenSendMessage.systemSendMessage(origResearch, vo, ContextHolder.get());
//                        }
//                    });
//                } catch (Exception e) {
//                    e.printStackTrace();
//                }
//            }
//        }
        researchMapper.insert(origResearch);
        return origResearch;
    }

    /**
     * 查看已完成和未完成的调研列表
     */
    @Override
    public Page<Research> apiListPage(BaseModel<PageVo> model) {
        PageVo pageVo = model.getObj();
        Page<Research> page = new Page<>(pageVo.getPageNo(), pageVo.getPageSize());

        RequestContext context = model.getContext();
        // 查出指定学员可见的调研id
        List<Long> researchIdsInRange = null;
        if (!CollectionUtils.isEmpty(context.getRelationIds())) {
            researchIdsInRange = researchAuthorizeMapper.getResearchIdsInRange(context.getRelationIds());
        }
        List<Research> records = researchMapper.apiListResearch(researchIdsInRange, context.getAccountId(),
                context.getSiteId(), model.getDate(), pageVo.getState(), pageVo.getBizType(), new RowBounds(page.getOffset(), page.getLimit()));

        if (!CollectionUtils.isEmpty(records)) {
            for (Research r : records) {

                TrResearchAnswer answer = new TrResearchAnswer();
                answer.setResearchId(r.getId());
                answer.setAccountId(context.getAccountId());
                answer.setFinish(1);
                EntityWrapper<TrResearchAnswer> wrapper = new EntityWrapper<TrResearchAnswer>(answer);
                List<TrResearchAnswer> answers = researchAnswerMapper.selectList(wrapper);
                if (answers.size() > 0) {
                    r.setFinishState(1);
                }
            }
        }
        // 如果是已完成：还要判断是否过期
        if (pageVo.getState() != null && pageVo.getState().equals(1)) {
            if (!CollectionUtils.isEmpty(records)) {
                Map<Long, Research> map = new LinkedHashMap<>();
                for (Research r : records) {
                    map.put(r.getId(), r);
                }
                TrResearchAnswer answer = new TrResearchAnswer();
                answer.setAccountId(context.getAccountId());
                EntityWrapper<TrResearchAnswer> ew = new EntityWrapper<>(answer);
                ew.in("research_id", map.keySet());
                List<TrResearchAnswer> answers = researchAnswerMapper.selectList(ew);

                if (!CollectionUtils.isEmpty(answers)) {
                    for (TrResearchAnswer a : answers) {
                        // 有答案，已完成
                        if (null != map.get(a.getResearchId())) {
                            map.get(a.getResearchId()).setFinishState(ResearchConstant.STATE_FINISHED);
                            map.get(a.getResearchId()).setFinishTime(a.getSubmitTime());
                        }
                        // 已过期
                        else {
                            map.get(a.getResearchId()).setFinishState(ResearchConstant.STATE_DATED);
                        }
                    }
                }
            }
        }
        page.setRecords(records);
        int count = 0;
        count = researchMapper.selectListCount(researchIdsInRange, context.getAccountId(),
                context.getSiteId(), model.getDate(), pageVo.getState(), pageVo.getBizType());
        if (count < 0) {
            count = 0;
        }

        page.setTotal(count);
        return page;
    }

    @Override
    public Page<Research> apiSearchPage(String name, RequestContext context, int pageNo, int pageSize) {
        Page<Research> page = new Page<>(pageNo, pageSize);

        // 查出指定学员可见的调研id
        List<Long> researchIdsInRange = null;
        if (!CollectionUtils.isEmpty(context.getRelationIds())) {
            researchIdsInRange = researchAuthorizeMapper.getResearchIdsInRange(context.getRelationIds());
        }
        List<Research> records = researchMapper.apiSearchPage(context.getSiteId(), name, context.getAccountId(),
                new Date(), researchIdsInRange, new RowBounds(page.getOffset(), page.getLimit()));

        page.setRecords(records);
        return page;
    }


    /**
     * 获得一个序号
     *
     * @return
     */
    private String getResearchNo(Long siteId) {
        int count = researchMapper.selectAllCount(siteId);
        count++;
        //得到一个NumberFormat的实例
        NumberFormat nf = NumberFormat.getInstance();
        //设置是否使用分组
        nf.setGroupingUsed(false);
        //设置最大整数位数
        nf.setMaximumIntegerDigits(6);
        //设置最小整数位数
        nf.setMinimumIntegerDigits(6);

        return "DY" + nf.format(count);
    }


    @Override
    public Integer searchUnfinishCount(RequestContext context) {
        // 查出指定学员可见的调研id
        List<Long> researchIdsInRange = null;
        if (!CollectionUtils.isEmpty(context.getRelationIds())) {
            researchIdsInRange = researchAuthorizeMapper.getResearchIdsInRange(context.getRelationIds());
        }
        Integer i = researchMapper.apiCountResearch(researchIdsInRange, context.getAccountId(), context.getSiteId(), new Date());
        return i;
    }

    @Override
    public Integer checkResearchState(Long researchId, RequestContext context) {
        List<Long> relationIds = context.getRelationIds();
        if (null == relationIds) {
            relationIds = new ArrayList<Long>();
            relationIds.add(context.getAccountId());
        }
        Date date = new Date();
        //根据researchId查询出人员范围
        Research research = new Research();
        research.setId(researchId);
        Integer visibleRange = researchMapper.selectOne(research).getVisibleRange();
        //根据
        //1.先判断有答案的，肯定是已完成的 1
        TrResearchAnswer answer = new TrResearchAnswer();
        answer.setAccountId(context.getAccountId());
        answer.setResearchId(researchId);
        answer.setFinish(1);
        EntityWrapper<TrResearchAnswer> wrapper = new EntityWrapper<>(answer);
        List<TrResearchAnswer> list = researchAnswerMapper.selectList(wrapper);
        if (list.size() > 0) {
            return 1;
        }
        //2.没有答案：时间还没到结束时间，进行中 2
        Integer num = 0;
        try {
            num = researchAnswerMapper.checkResearchAnswer(visibleRange,context.getAccountId(), researchId, relationIds, date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (num == 0) {
            return 2;
        }
        //3.没有答案:时间>结束时间，过期 3
        num = researchAnswerMapper.checkResearchAnswerState(visibleRange, context.getAccountId(),researchId, relationIds, date);
        if (num == 0) {
            return 3;
        }
        //4.这些情况都没有，无效的
        return 4;

    }

    @Override
    public Page<Research> getResearchList(String startDate, String endDate, String kwd, Integer pageSize, Integer pageNo, List<Long> orgIds, Long companyId, Long siteId) {
        List<Research> researchList;
        Page<Research> page = new Page<Research>(pageNo, pageSize);
        RowBounds researchRowBounds = new RowBounds(page.getOffset(), page.getLimit());
        /*if (companyId != null) {
            research.setCompanyId(companyId); /
        }/ 根据公司id查找
        research.setSiteId(siteId);
        EntityWrapper<Research> wrapper = new EntityWrapper<Research>(research);
        if(null != kwd){
            wrapper.like("name",kwd);
        }
        if(!CollectionUtils.isEmpty(orgIds)){
            wrapper.in("org_id",orgIds);
        }*/
        researchList = researchMapper.selectResearchPage(startDate, endDate, kwd, orgIds, companyId, siteId, researchRowBounds);
        if (CollectionUtils.isEmpty(researchList)) {
            return null;
        }
        selectRealCount(researchList);
        installRelationIds(researchList);
        page.setTotal(researchMapper.selectResearchCount(startDate, endDate, kwd, orgIds, companyId, siteId));
        page.setRecords(researchList);
        return page;
    }
    
    @Override
    public List<Research> apiVoteManagementForScroll(BaseModel<PageVo> model) {
        RequestContext context = model.getContext();
        Date now = new Date();
        // 查出指定学员可见的调研id
        List<Long> researchIdsInRange = null;
        if (!CollectionUtils.isEmpty(context.getRelationIds())) {
            researchIdsInRange = researchAuthorizeMapper.getResearchIdsInRange(context.getRelationIds());
        }
        
        // 调用Mapper中的新方法获取4天内创建的投票管理数据
        List<Research> researchList = this.baseMapper.selectVoteManagementForScroll(researchIdsInRange, context.getSiteId(), now);


        return researchList;
    }

    //设置实际参加人数
    public void selectRealCount(List<Research> list) {
        if (list.size() == 0) {
            return;
        }
        List<Long> researchIds = new ArrayList<Long>();
        for (Research research : list) {
            researchIds.add(research.getId());
        }
        if (list != null && list.size() > 0) {
            LinkedList<Research> realJoin = researchMapper.selectRealJoin(researchIds);
            Iterator<Research> it;
            for (Research research : list) {
                it = realJoin.iterator();
                Research re;
                while (it.hasNext()) {
                    re = it.next();
                    if (research.getId().equals(re.getId())) {
                        Integer realCount = re.getRealCount();
                        if (realCount == null) {
                            realCount = 0;
                        }
                        research.setRealCount(realCount);
                    }
                }
            }
        }
    }

    //设置每个调研关联的人员
    public void installRelationIds(List<Research> list) {
        if (list.size() == 0) {
            return;
        }
        List<Long> researchIds = new ArrayList<Long>();
        for (Research research : list) {
            researchIds.add(research.getId());
        }
        LinkedList<TrResearchAuthorize> authorizes;
        if (list != null && list.size() > 0) {

            authorizes = researchMapper.selectRelationIds(researchIds);

            /*Map<Long,List<Long>> map=new HashMap<Long,List<Long>>();
            for(Research research : relevance){
                if(map.containsKey(research.getId())){
                    map.get(research.getId()).add(research.getRelationIds());
                }else{
                    List<Long> longs= new LinkedList<>();
                    longs.add(research.getRelationIds());
                    map.put(research.getId(),longs);
                }
            }
            Set<Long> set=map.keySet();*/
            Iterator<TrResearchAuthorize> it;
            TrResearchAuthorize authorize;
            for (Research research : list) {
                List<Long> longs;
                Integer visibleRange = research.getVisibleRange();
                if (visibleRange == null) {
                    visibleRange = 1;
                }
                if (visibleRange == 2) {
                    longs = new ArrayList<Long>();
                    it = authorizes.iterator();
                    while (it.hasNext()) {
                        authorize = it.next();
                        if (research.getId().equals(authorize.getResearchId())) {
                            Long l = authorize.getRelationId();
                            longs.add(l);
                        }
                    }
                    research.setRelationIds(longs);
                }
            }
        }
    }
    @Override
    public Research getResearchView(Long researchId) {
        Map<Research, List<TrResearchAnswer>> map = new HashMap<Research, List<TrResearchAnswer>>();
        Research research = new Research();
        research.setId(researchId);
        research = researchMapper.selectOne(research);
        List<Long> relationIds = new LinkedList<>();
        if (research == null) {
            return null;
        }
        List<Long> researchIds = new LinkedList<Long>();
        researchIds.add(researchId);
        TrResearchAnswer trResearchAnswer = new TrResearchAnswer();
        trResearchAnswer.setResearchId(researchId);
        EntityWrapper<TrResearchAnswer> entityWrapper = new EntityWrapper<TrResearchAnswer>(trResearchAnswer);
        List<TrResearchAnswer> list = researchAnswerMapper.selectList(entityWrapper);
        if (research.getVisibleRange() == 2) {
            List<TrResearchAuthorize> trResearchAuthorizes = researchMapper.selectRelationIds(researchIds);
            for (TrResearchAuthorize trResearchAuthorize : trResearchAuthorizes) {
                relationIds.add(trResearchAuthorize.getRelationId());
            }
            research.setRelationIds(relationIds);
        }
        research.setTrResearchAnswers(list);
        return research;
    }


    @Override
    public VisibleRangeExport vsibleRangeExport(Long researchId) {// TODO Auto-generated method stub
        VisibleRangeExport visibleRangeExport = new VisibleRangeExport();
        List<Long> accountIds = new ArrayList<Long>();
        List<Long> orgIds = new ArrayList<Long>();


        Research research = researchMapper.selectById(researchId);
        if (research != null) {
            visibleRangeExport.setBizId(research.getId());
            visibleRangeExport.setBizName(research.getName());
        }


        List<TrResearchAuthorize> listStudent = researchAuthorizeService.listTrResearchAuthorize(researchId);
        if (listStudent != null && listStudent.size() > 0) {
            TrResearchAuthorize researchAuthorize = null;
            for (int i = 0; i < listStudent.size(); i++) {
                researchAuthorize = listStudent.get(i);
                if (researchAuthorize != null && researchAuthorize.getType() != null) {
                    if (researchAuthorize.getType() == 2) {
                        accountIds.add(researchAuthorize.getRelationId());
                    }
                    if (researchAuthorize.getType() == 1) {
                        orgIds.add(researchAuthorize.getRelationId());
                    }
                }
                visibleRangeExport.setAccountIds(accountIds);
                visibleRangeExport.setOrgIds(orgIds);
            }
        }

        return visibleRangeExport;

    }

    @Override
    public Page<Map<String, Object>> getPoolExamList(String name, List<Long> ids, Integer pageNo, Integer pageSize) {
        HQueryUtil.startHQ(Research.class);

        RequestContext res = ContextHolder.get();
        Long companyId = res.getCompanyId();
        Long siteId = res.getSiteId();
        List<Long> orgIds = null;
        Page<Map<String, Object>> page = new Page<>(pageNo, pageSize);
        List<Map<String, Object>> list = new ArrayList<>();
        if (!res.isAdmin() && !CollectionUtils.isEmpty(res.getOrgIds())) {
            orgIds = res.getOrgIds();
        }
        String name1 = null;
        if (!StringUtils.isEmpty(name)){
            name1= name.trim();
        }
        list =  researchMapper.getPoolExamList(name1, ids, companyId, siteId, orgIds, page);
        if (!CollectionUtils.isEmpty(list)){
            page.setRecords(list);
        }
        return page;
    }


    @Override
    public List<Map<String, Object>> getServerByCompanyIdAndIds(Long companyId, List<Long> ids) {
        // TODO Auto-generated method stub
        List<Map<String, Object>> listMap=null;
        //查询
        Research research=new Research();
        research.setCompanyId(companyId);
        EntityWrapper<Research> wrapper=new EntityWrapper<Research>(research);
        if(!CollectionUtils.isEmpty(ids)) {
            wrapper.in("id", ids);
        }
        List<Research> listResearch=this.selectList(wrapper);
        //循环组装到输出对象
        Map<String, Object> map=null;
        if(!CollectionUtils.isEmpty(listResearch)) {
            listMap=new ArrayList<Map<String, Object>>();
            for (Research c:listResearch) {
                map=new HashMap<String, Object>();
                map.put("catalog", 2);
                map.put("id", c.getId());
                map.put("name", c.getName());
                map.put("logo_url", "");
                listMap.add(map);
            }
        }
        return listMap;
    }

    @Override
    public Page<Research> getPageToCalendar(Date date, Page<Research> page) {
        RequestContext context = ContextHolder.get();
        //获取当天的调研ids
        List<Long> ids = researchMapper.getIdsByDate(date, context.getSiteId());
        if (CollectionUtils.isEmpty(ids)){
            return page;
        }

        //根据可见范围获取调研ids
        List<Long> trIds = trResearchAuthorizeMapper.getUsefulIds(ids,context.getRelationIds(), context.getSiteId());
        //获取已完成的调研ids
        List<Long> finishTrIds = researchAnswerMapper.getFinshIdsByIds(ids,context.getAccountId(),context.getSiteId());
        page.setRecords(researchMapper.getPageToCalendar(finishTrIds, trIds, date, context.getSiteId(), page));
        page.setTotal(researchMapper.getPageToCalendarNum(finishTrIds, trIds, date, context.getSiteId()));
        return page;
    }

    @Override
    public Page<DroolsVo> getPageByDrools(String field, String value, Page<DroolsVo> page) {
        if (StringUtils.isEmpty(field)) {
            LOG.info("列名不能为空！");
            return page;
        }

        if (field.equalsIgnoreCase(TaskParamsEnums.NAME.getCode())) {
            return getPage(field, value, page);
        } else if (field.equalsIgnoreCase(TaskParamsEnums.KEYWORD.getCode())) {
            field = "keywords";
            return getPage(field, value, page);
        }
        return page;
    }

    public Page getPage(String field, String value, Page<DroolsVo> page) {
        RequestContext requestContext = ContextHolder.get();
        Long siteId = requestContext.getSiteId();
        Long companyId = requestContext.getCompanyId();

        Research research = new Research();
        research.setSiteId(siteId);
        research.setCompanyId(companyId);
        research.setState(1);
        research.setDeleted(0);
        EntityWrapper wrapper = new EntityWrapper(research);
        wrapper.setSqlSelect("distinct(" + field + "),"+"id ")
                .isNotNull(field)
                .like(field, value)
                .addFilter(field+"!=''")
                .orderBy("create_time", false);

        String upperField = ClassUtil.getFieldName(field);
        List<DroolsVo> voList = null;
        List<Research> list = this.baseMapper.selectPage(page, wrapper);
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            voList = new ArrayList<>(list.size());

            for (Research a : list) {
                DroolsVo vo = new DroolsVo();
                vo.setTaskId(a.getId());
                vo.setTaskFieldValue(ClassUtil.invokeMethod(a, upperField));
                vo.setTaskParamsType(field);
                voList.add(vo);
            }
            page.setRecords(voList);
        }
        return page;
    }


    @Override
    public Research viewInfo(Long id) {
        Research research = researchMapper.selectById(id);
        return research;
    }


    @Override
    public List<ResearchVo> getResearchTop(Integer bizType) {
        RequestContext requestContext = ContextHolder.get();
        Long siteId = requestContext.getSiteId();
        return researchMapper.getResearchTop(bizType, siteId);
    }


    @Override
    public ResearchVo getResearchDetails(Long id) {
        RequestContext requestContext = ContextHolder.get();
        if(requestContext == null){
            return null;
        }

        ResearchVo research = researchMapper.selectResearchDetails(id, requestContext.getAccountId(), requestContext.getSiteId());
        //投票完成或过期选择次数0
        if(research.getFinishState() == 1 || research.getFinishState() == 3){
            research.setVoteNum(0);
        }


        TrResearchAnswer answer = new TrResearchAnswer();
        answer.setResearchId(research.getId());
        answer.setAccountId(requestContext.getAccountId());
        answer.setFinish(1);
        EntityWrapper<TrResearchAnswer> wrapper = new EntityWrapper<TrResearchAnswer>(answer);
        List<TrResearchAnswer> answers = researchAnswerMapper.selectList(wrapper);
        if (answers.size() > 0) {
            research.setFinishState(1);
        }

        return research;
    }

    @Override
    public Integer checkTPlanResearchState(Long researchId, RequestContext context) {
        // 查出指定学员可见的调研id
        List<Long> researchIdsInRange = null;
        if (!CollectionUtils.isEmpty(context.getRelationIds())) {
            researchIdsInRange = researchAuthorizeMapper.getResearchIdsInRange(context.getRelationIds());
        }
       return researchMapper.checkTPlanResearchState(researchIdsInRange, researchId, context.getSiteId());
    }
}
