package com.yizhi.research.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.research.application.mapper.TrResearchAuthorizeMapper;
import com.yizhi.research.application.service.ITrResearchAuthorizeService;
import com.yizhi.research.application.vo.domain.TrResearchAuthorize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 调研用户范围 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Service
public class TrResearchAuthorizeServiceImpl extends ServiceImpl<TrResearchAuthorizeMapper, TrResearchAuthorize> implements ITrResearchAuthorizeService {

    private Logger logger = LoggerFactory.getLogger(TrResearchAuthorizeServiceImpl.class);

    @Autowired
    private IdGenerator idGenerator;

    @Override
    @Transactional
    public Boolean insertAll(List<TrResearchAuthorize> trResearchAuthorizes) {
        if (!CollectionUtils.isEmpty(trResearchAuthorizes)) {
            Long researchId = trResearchAuthorizes.get(0).getResearchId();
            TrResearchAuthorize trResearchAuthorize = new TrResearchAuthorize();
            trResearchAuthorize.setResearchId(researchId);
            trResearchAuthorize.setState(1);
            EntityWrapper<TrResearchAuthorize> entityWrapper = new EntityWrapper<>(trResearchAuthorize);
            this.baseMapper.delete(entityWrapper);
            for (TrResearchAuthorize trResearchAuthorize1 : trResearchAuthorizes) {
                trResearchAuthorize1.setId(idGenerator.generate());
            }
            return this.insertBatch(trResearchAuthorizes);
        } else {
            logger.error("列表为空");
            return Boolean.FALSE;
        }

    }

	@Override
	public List<TrResearchAuthorize> listTrResearchAuthorize(Long researchId) {
		// TODO Auto-generated method stub
		TrResearchAuthorize researchAuthorize = new TrResearchAuthorize();
		researchAuthorize.setResearchId(researchId);
		researchAuthorize.setState(1);//有效
		EntityWrapper<TrResearchAuthorize> wrapper=new EntityWrapper<TrResearchAuthorize>(researchAuthorize);
		return this.selectList(wrapper);
	}
}
