package com.yizhi.research.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.research.application.mapper.TrResearchQuestionOptionMapper;
import com.yizhi.research.application.service.ITrResearchQuestionOptionService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.research.application.vo.domain.TrResearchQuestionOption;
import com.yizhi.research.application.vo.manage.OtherOptionVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 只对题型是：单选题、多选题和打分题 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Service
public class TrResearchQuestionOptionServiceImpl extends ServiceImpl<TrResearchQuestionOptionMapper, TrResearchQuestionOption> implements ITrResearchQuestionOptionService {

    @Autowired
    private TrResearchQuestionOptionMapper trResearchQuestionOptionMapper;
    @Override
    public List<TrResearchQuestionOption> listAll(Long researchId) {

        return trResearchQuestionOptionMapper.listAllByResearchId(researchId);
    }

    @Override
    public Map<String,Object> getOptionByQuestionId(Long id) {
        Map<String,Object> map = new HashMap<String, Object>(4);
        map.put("question_id",id);
        List<TrResearchQuestionOption> options = trResearchQuestionOptionMapper.selectByMap(map);
        OtherOptionVo otherOptionVo = null;
        List<TrResearchQuestionOption> op = new ArrayList<>(50);
        for(TrResearchQuestionOption option :options){
            if(option.getJumpNum() == null || option.getJumpNum() == -1){
                option.setJumpNum(null);
            }
            if(option.getIsOther() != null && option.getIsOther() == 1){
                op.add(option);
                otherOptionVo = new OtherOptionVo();
                otherOptionVo.setRequired(option.getRequired());
                otherOptionVo.setNo(option.getNo());
                otherOptionVo.setJumpNum(option.getJumpNum());
                otherOptionVo.setEditable(option.getEditable());
                otherOptionVo.setContent(option.getContent());
                otherOptionVo.setId(option.getId());
            }
        }
        options.removeAll(op);
        map.put("options",options);
        map.put("otherOption",otherOptionVo);
        return map;
    }

}
