package com.yizhi.research.application.service.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.core.application.publish.CloudEventPublisher;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.research.application.mapper.*;
import com.yizhi.research.application.model.ModifyQuestionModel;
import com.yizhi.research.application.service.ITrResearchQuestionAttachmentService;
import com.yizhi.research.application.service.ITrResearchQuestionService;
import com.yizhi.research.application.vo.api.AnswerQuestionItemVo;
import com.yizhi.research.application.vo.api.AnswerQuestionVo;
import com.yizhi.research.application.vo.api.MyQuestion;
import com.yizhi.research.application.vo.api.QuestionJumpVo;
import com.yizhi.research.application.vo.domain.*;
import com.yizhi.research.application.vo.manage.OtherOptionVo;
import com.yizhi.util.application.constant.QueueConstant;
import com.yizhi.util.application.constant.TpActivityType;
import com.yizhi.util.application.event.TrainingProjectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * <p>
 * 问题 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Service
@Transactional
public class TrResearchQuestionServiceImpl extends ServiceImpl<TrResearchQuestionMapper, TrResearchQuestion> implements ITrResearchQuestionService {

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private TrResearchQuestionMapper researchQuestionMapper;
    @Autowired
    private TrResearchQuestionOptionMapper researchQuestionOptionMapper;
    @Autowired
    private TrResearchAnswerMapper trResearchAnswerMapper;
    @Autowired
    private TrResearchAnswerQuestionMapper trResearchAnswerQuestionMapper;
    @Autowired
    private ResearchMapper researchMapper;
    @Autowired
    private TrResearchAnswerQuestionResultMapper trResearchAnswerQuestionResultMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private CloudEventPublisher cloudEventPublisher;

    @Autowired
    private TrResearchQuestionAttachmentMapper researchQuestionAttachmentMapper;

    @Autowired
    private ITrResearchQuestionAttachmentService researchQuestionAttachmentService;

    private static final Logger LOG = LoggerFactory.getLogger(TrResearchQuestionServiceImpl.class);

    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public int batchInsert(List<TrResearchQuestion> researchQuestions) {
        LOG.info("batchInsert入参:{}", JSONUtil.toJsonStr(researchQuestions));
        boolean hasOptions = false;

        Map<String, Object> map = new HashMap<String, Object>(4);
        List<TrResearchQuestionOption> optionListToInsert = new ArrayList<>();
        Integer size = 0;
        if (researchQuestions != null) {
            TrResearchQuestion rq = researchQuestions.get(0);
            if (rq != null) {
                Long researchId = rq.getResearchId();
                map.put("research_id", researchId);
                List<TrResearchQuestion> questions = researchQuestionMapper.selectByMap(map);
                size = getMaxNo(questions);
            }
        } else {
            return -1;
        }
        // 给问题id赋值
        for (TrResearchQuestion question : researchQuestions) {
            question.setJumpType(2);
            question.setId(idGenerator.generate());
            question.setDeleted(0);
            question.setNo(++size);
            // 给问题选项id赋值
            List<TrResearchQuestionOption> optionList = question.getOptions();
            if (!CollectionUtils.isEmpty(optionList)) {
                hasOptions = true;
                for (TrResearchQuestionOption option : optionList) {
                    option.setId(idGenerator.generate());
                    option.setQuestionId(question.getId());
                    option.setResearchId(question.getResearchId());
                    optionListToInsert.add(option);
                }
            }
            
            //添加问题相关附件
            if (!CollectionUtils.isEmpty(question.getAttachmentUrl())) {
            	List<TrResearchQuestionAttachment> attachments = new ArrayList<TrResearchQuestionAttachment>();
            	TrResearchQuestionAttachment save = null;
            	for(String url : question.getAttachmentUrl()){
            		save = new TrResearchQuestionAttachment();
            		save.setId(idGenerator.generate());
            		save.setContentAppendixUrl(url);
            		save.setResearchQuestionId(question.getId());
            		save.setDeleted(0);
            		save.setCreateById(question.getCreateById());
            		save.setCreateByName(question.getCreateByName());
            		save.setCreateTime(question.getCreateTime());
            		save.setUpdateById(question.getUpdateById());
            		save.setUpdateByName(question.getUpdateByName());
            		save.setUpdateTime(question.getUpdateTime());
            		
            		attachments.add(save);
            	}
            	researchQuestionAttachmentService.insertBatch(attachments);
            }
        }

        int num = researchQuestionMapper.batchInsert(researchQuestions);
        if (num > 0 && hasOptions) {
            researchQuestionOptionMapper.batchInsert(optionListToInsert);
        }

        return num;
    }

    @Override
    public int updateNo(QuestionJumpVo vo){
        if(vo.getQuestionId()!=null){
            TrResearchQuestion question = researchQuestionMapper.selectById(vo.getQuestionId());
            if(question==null){
                return 0;
            }
            List<TrResearchQuestion> questionList = researchQuestionMapper.listAllForJump(0,question.getResearchId());
            if(CollectionUtils.isEmpty(questionList)){
                return 0;
            }
            Optional<TrResearchQuestion>  optional = questionList.stream().filter(q->Objects.equals(q.getNo(),vo.getNo())).findFirst();
            if(optional!=null&&optional.isPresent()){
                TrResearchQuestion trResearchQuestion = optional.get();
                 researchQuestionMapper.updateQNoById(trResearchQuestion.getId(),question.getNo());
            }
            return researchQuestionMapper.updateQNoById(vo.getQuestionId(),vo.getNo());
        }
        return 0;
    }

    @Override
    public int batchUpdate(ModifyQuestionModel modifyQuestionModel) throws Exception {
        int result = 0;
        boolean hasOptions = false;
        boolean needChangeNo = false;

        TrResearchQuestion questions;

        // 删除的
        List<Long> ids = modifyQuestionModel.getDeletedIds();
        Map<String, Object> map = new HashMap<>(4);
        map.put("research_id", modifyQuestionModel.getResearchId());
        map.put("deleted", 0);
        List<TrResearchQuestion> qs = researchQuestionMapper.selectByMap(map);
        TrResearchQuestion q;
        QuestionJumpVo vo;
        List<Integer> deleteQuestionNo=new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(ids)) {
            for (Long id : ids) {
                q = researchQuestionMapper.selectById(id);
                deleteQuestionNo.add(q.getNo());
                for (TrResearchQuestion question : qs) {
                    List<TrResearchQuestionOption> options = researchQuestionOptionMapper.listAllByQuestionId(question.getId());
                    if (!CollectionUtils.isEmpty(options)) {
                        for (TrResearchQuestionOption option : options) {
                            if (option.getJumpNum() != null && option.getJumpNum().equals(q.getNo())) {
                                researchQuestionMapper.updateNo(option.getId(), null);
                            }
                        }
                    }
                    if (question.getJumpType() != null && question.getJumpType() == 2 && q.getNo().equals(question.getJumpNum()) && !question.getId().equals(q.getId())) {
                        //删除的问题关联跳题
                        researchQuestionMapper.updateNoById(question.getId(), null);
                    }
                }
            }
            try {
                TrResearchQuestion question = new TrResearchQuestion();
                question.setDeleted(0);
                question.setResearchId(modifyQuestionModel.getResearchId());
                List<TrResearchQuestion> questionList = researchQuestionMapper.selectList(new EntityWrapper<>(question));
                TrResearchQuestionOption option = new TrResearchQuestionOption();
                option.setDeleted(0);
                option.setResearchId(modifyQuestionModel.getResearchId());
                List<TrResearchQuestionOption> options = researchQuestionOptionMapper.selectList(new EntityWrapper<>(option));
                Map<Long, Integer> optionToQuestion = new HashMap<Long, Integer>();
                for (TrResearchQuestionOption o : options) {
                    TrResearchQuestion question1 = researchQuestionMapper.selectById(o.getQuestionId());
                    optionToQuestion.put(o.getId(), question1.getNo());
                }
                //获取选项跳向当前题号的题目
                Map<Integer, List<Long>> noToOption = getNoToOptions(options, questionList);
                Set<Integer> nos = noToOption.keySet();

                //获取当前题号和题目的对应关系
                Map<Integer, Long> old = getCurrentQuestion(questionList);
                Set<Long> updateQuestions;

                //获取题目跳向当前题号的题目
                Map<Integer, List<Long>> noToQuestion = getNoToQuestions(questionList);
                Set<Integer> ss = noToQuestion.keySet();
                List<Long> questionIds;
                List<Long> optionIds;
                for (Integer no : deleteQuestionNo) {
                    updateQuestions = new HashSet<>();
                    for (TrResearchQuestion s : questionList) {
                        if (no < s.getNo()) {
                            questionIds = new ArrayList<>();
                            for(Integer i : ss){
                                List<Long> questionId = noToQuestion.get(s.getNo());
                                if(i>=s.getNo() && questionId!=null){
                                    questionIds.addAll(questionId);
                                }
                            }
                            updateQuestions.add(old.get(s.getNo()));
                            //将这些question 的jumpNum减一
                            if(!CollectionUtils.isEmpty(questionIds)) {
                                researchQuestionMapper.updateJumpNum(questionIds);
                            }
                            optionIds = new ArrayList<>();
                            for(Integer i :nos){
                                List<Long> optionId = noToOption.get(s.getNo());
                                if(i>=s.getNo() &&optionId!=null){
                                    optionIds.addAll(optionId);
                                }
                            }
                            if(!CollectionUtils.isEmpty(optionIds)) {
                                researchQuestionOptionMapper.updateJumpNum(optionIds);
                            }
                        }
                    }
                    //将这questionId的no减一
                    if(!CollectionUtils.isEmpty(updateQuestions)) {
                        researchQuestionMapper.updateNos(updateQuestions);
                    }
                }
            }catch (Exception e){
                System.out.println("删除题目出错");
                e.printStackTrace();
                LOG.error("",e);
            }
            }
        if (!CollectionUtils.isEmpty(ids)) {
            result = researchQuestionMapper.batchDeleteById(ids);
            if (result != ids.size()) {
                throw new Exception("处理异常：删除的调研问题数目 和 传入的id集合长度 对不上，事务回滚！！");
            }

            // 删除下面选项
            for (Long questionId : ids) {
                questions = researchQuestionMapper.selectById(questionId);
                if (questions.getType() == 3) {
                    continue;
                }

                TrResearchQuestionOption example = new TrResearchQuestionOption();
                example.setQuestionId(questionId);
                example.setDeleted(0);

                List<TrResearchQuestionOption> optionsToDelete = researchQuestionOptionMapper.selectList(new EntityWrapper<TrResearchQuestionOption>(example));
                List<Long> optionsToDeleteIds = new ArrayList<Long>();
                for (TrResearchQuestionOption option : optionsToDelete) {
                    optionsToDeleteIds.add(option.getId());
                }
                if (!CollectionUtils.isEmpty(optionsToDeleteIds)) {
                    researchQuestionOptionMapper.batchDelete(optionsToDeleteIds, modifyQuestionModel.getDate(), modifyQuestionModel.getRequestContext().getAccountId(), modifyQuestionModel.getRequestContext().getAccountName());
                }
            }
            return result;
//            reBuildNo(modifyQuestionModel.getResearchId());
        }

        // 修改的（包括新增的）,参数
        List<TrResearchQuestionVo> researchQuestions = modifyQuestionModel.getQuestions();
        List<TrResearchQuestion> researchQuestionss = new ArrayList<>();
        if (!CollectionUtils.isEmpty(researchQuestions)){
            for (TrResearchQuestionVo v:researchQuestions
                 ) {
                TrResearchQuestion t=new TrResearchQuestion();
                BeanUtils.copyProperties(v,t);
                List<TrResearchQuestionOption> list=new ArrayList<>();
                if (!CollectionUtils.isEmpty(v.getOptions())){
                    for (TrResearchQuestionOptionVo tv:v.getOptions()) {
                        TrResearchQuestionOption to= new TrResearchQuestionOption();
                        BeanUtils.copyProperties(tv,to);
                        list.add(to);
                    }
                }
                t.setOptions(list);
                researchQuestionss.add(t);
            }
        }
        // 将要新增的问题
        List<TrResearchQuestion> newQuestions = new ArrayList<>();
        // 将要修改的问题
        List<TrResearchQuestion> modifyQuestions = new ArrayList<>();
        // 将要新增的问题option（修改其实就是删除以前的）
        List<TrResearchQuestionOption> newOptions = new ArrayList<>();
        // 将要删除选项的问题的id集合
        List<Long> questionIdsToDeleteOption = new ArrayList<>();

        if (!CollectionUtils.isEmpty(researchQuestions)) {
            for (TrResearchQuestion question : researchQuestionss) {
                // 新增的
                if (null == question.getId()) {
                    question.setDeleted(0);
                    question.setId(idGenerator.generate());
                }
                // 修改的问题
                if (question.getId() != null) {
                    needChangeNo = true;
                    modifyQuestions.add(question);
                    questionIdsToDeleteOption.add(question.getId());
                }
                // 给问题选项id赋值
                List<TrResearchQuestionOption> optionList = question.getOptions();
                if (!CollectionUtils.isEmpty(optionList)) {
                    hasOptions = true;
                    for (TrResearchQuestionOption option : optionList) {
                        option.setId(idGenerator.generate());
                        option.setQuestionId(question.getId());
                        option.setResearchId(question.getResearchId());
                        newOptions.add(option);
                    }
                }
                newQuestions.add(question);
//                LOG.info("==========看有没有传值选项list=======："+question.getOptions().toString());
//                LOG.info("=================："+newOptions.toString());

            }
        }

        // 删除旧选项
        EntityWrapper<TrResearchQuestionOption> ew = new EntityWrapper<>();
        if (!CollectionUtils.isEmpty(questionIdsToDeleteOption)) {
            ew.in("question_id", questionIdsToDeleteOption);
            if (!CollectionUtils.isEmpty(newOptions)){
                researchQuestionOptionMapper.delete(ew);
            }
        }

        if (!CollectionUtils.isEmpty(newQuestions) && !needChangeNo) {
        	result += researchQuestionMapper.batchInsert(newQuestions);
        }
        if (!CollectionUtils.isEmpty(newOptions)) {
            researchQuestionOptionMapper.batchInsert(newOptions);
        }
        if (!CollectionUtils.isEmpty(modifyQuestions) && needChangeNo) {
            for (TrResearchQuestion question : modifyQuestions) {
                result += researchQuestionMapper.updateById(question);
            }
        }
        
        
        //删除问题相关图片
		if (!CollectionUtils.isEmpty(researchQuestions)) {
			RequestContext context = ContextHolder.get();
			Date date = new Date();
			List<TrResearchQuestionAttachment> attachments = new ArrayList<TrResearchQuestionAttachment>();
			for (TrResearchQuestionVo question : researchQuestions) {
				//删除问题相关的附件
				researchQuestionAttachmentMapper.delQuestionAttachmentByQuestionId(question.getId());
				
				// 添加问题相关附件
				if (!CollectionUtils.isEmpty(question.getAttachmentUrl())) {
					TrResearchQuestionAttachment save = null;
					for (String url : question.getAttachmentUrl()) {
						save = new TrResearchQuestionAttachment();
						save.setId(idGenerator.generate());
						save.setContentAppendixUrl(url);
						save.setResearchQuestionId(question.getId());
						save.setDeleted(0);
						save.setCreateById(context.getAccountId());
						save.setCreateByName(context.getAccountName());
						save.setCreateTime(date);
						save.setUpdateById(context.getAccountId());
						save.setUpdateByName(context.getAccountName());
						save.setUpdateTime(date);

						attachments.add(save);
					}
				}
			}
			if (!CollectionUtils.isEmpty(attachments)) {
				researchQuestionAttachmentService.insertBatch(attachments);
			}
		}

        
//        if (needChangeNo) {
//            reBuildNo(modifyQuestionModel.getResearchId());
//        }
        return result;
    }

    @Override
    public List<TrResearchQuestion> listPage(Map<String, Object> map) {
        Long researchId = (Long) map.get("researchId");
        Integer pageNo = 1;
        Integer pageSize = Integer.MAX_VALUE;
        if (map.get("pageNo") != null) {
            pageNo = (Integer) map.get("pageNo");
        }
        if (map.get("pageSize") != null) {
            pageSize = (Integer) map.get("pageSize");
        }
        TrResearchQuestion example = new TrResearchQuestion();
        example.setResearchId(researchId);
        example.setDeleted(0);
        EntityWrapper<TrResearchQuestion> ew = new EntityWrapper<>(example);
        ew.orderBy("no", true);
        ew.last("limit " + (pageNo - 1) * pageSize + "," + pageSize);
        List<TrResearchQuestion> records = researchQuestionMapper.selectList(ew);
        OtherOptionVo otherOptionVo = null;
        // 组装问题选项
        if (!CollectionUtils.isEmpty(records)) {
            Integer maxNo = getMaxNo(researchId);
            for (TrResearchQuestion question : records) {

                Research research = researchMapper.selectById(question.getResearchId());
                if(research != null) {
                    question.setStyleType(research.getStyleType());
                }

                Integer has = checkJump(question.getId(), example.getResearchId());
                question.setHas(has);
                if (question.getJumpType() == 2 && (question.getJumpNum() == null || question.getJumpNum() == -1)) {
                    question.setJumpNum(null);
                }
                //调研按选项跳题后,选项按顺序填写(jumpNum = -1时,相当于null)
                if (question.getJumpType() == 1 && (question.getJumpNum() == null || question.getJumpNum() == -1)){
                    question.setJumpNum(null);
                }
                if (question.getNo().equals(maxNo)) {
                    question.setIsLast(1);
                }
                List<TrResearchQuestionOption> options = researchQuestionOptionMapper.listAllByQuestionId(question.getId());
                if (options != null) {
                    for (TrResearchQuestionOption option : options) {
                        if (question.getJumpType() == 1 && (option.getJumpNum() == null || -1 == option.getJumpNum())) {
                            option.setJumpNum(null);
                        }
                        if (option.getIsOther() != null && option.getIsOther() == 1) {
                            question.setHasOther(1);
                            options.remove(option);
                            otherOptionVo = new OtherOptionVo();
                            otherOptionVo.setId(option.getId());
                            otherOptionVo.setJumpNum(option.getJumpNum());
                            otherOptionVo.setContent(option.getContent());
                            otherOptionVo.setEditable(option.getEditable());
                            otherOptionVo.setNo(option.getNo());
                            otherOptionVo.setRequired(option.getRequired());
                            question.setOtherOptionVo(otherOptionVo);
                            break;
                        }
                    }
                    question.setOptionContent(options.get(0).getContent());
                }
                
                //获取题目相关的附件
                List<String> attachmentUrl = researchQuestionAttachmentMapper.selectQuestionAttachmentByQuestionId(question.getId());
                question.setAttachmentUrl(attachmentUrl);
                question.setOptions(options);

            }
        }
        
        return records;
    }

    @Override
    public List<TrResearchQuestion> listAll(Long researchId) {
        TrResearchQuestion question = new TrResearchQuestion();
        question.setResearchId(researchId);
        question.setDeleted(0);
        EntityWrapper<TrResearchQuestion> ew = new EntityWrapper<>(question);
        ew.orderBy("no", true);
        List<TrResearchQuestion> questionList = researchQuestionMapper.selectList(ew);
        LOG.info("获取投票列表返回 questionList:{}", JSONUtil.toJsonStr(questionList));

        TrResearchQuestionOption option = new TrResearchQuestionOption();
        option.setDeleted(0);
        option.setResearchId(researchId);
        EntityWrapper<TrResearchQuestionOption> ew1 = new EntityWrapper<>(option);
        List<TrResearchQuestionOption> optionList = researchQuestionOptionMapper.selectList(ew1);


        Research research = researchMapper.selectById(researchId);

        // 组装 question questionOption
        Map<Long, TrResearchQuestion> map = new HashMap<>();

        for (TrResearchQuestion item : questionList) {
            item.setResearchName(research.getName());
            item.setResearchContent(research.getContent());
            if (research.getStartTime() != null) {
                item.setStartTime(dateFormat.format(research.getStartTime()));
            }
            if (research.getEndTime() != null) {
                item.setEndTime(dateFormat.format(research.getEndTime()));
            }
            map.put(item.getId(), item);
            // 设置跳过的题号\
            if (item.getJumpType() == 2 && item.getJumpNum() != null && item.getJumpNum() != -1) {
                item.setJumpedNums(buildJumpedNums(item.getNo(), item.getJumpNum()));
            }
        }

        for (TrResearchQuestionOption item : optionList) {
            if (map.get(item.getQuestionId()) != null) {
                if (CollectionUtils.isEmpty(map.get(item.getQuestionId()).getOptions())) {
                    map.get(item.getQuestionId()).setOptions(new ArrayList<TrResearchQuestionOption>());
                }
                map.get(item.getQuestionId()).getOptions().add(item);
            }
            // 设置跳过的题号
            if (item.getJumpNum() != null && item.getJumpNum() != -1) {
                item.setJumpedNums(buildJumpedNums(map.get(item.getQuestionId()).getNo(), item.getJumpNum()));
            }
        }
        return questionList;
    }

    @Override
    public List<TrResearchQuestion> listAllForJump(Long questionId) {
        TrResearchQuestion trResearchQuestion = researchQuestionMapper.selectById(questionId);
        if (trResearchQuestion != null) {
        	List<TrResearchQuestion> listAllForJump = researchQuestionMapper.listAllForJump(trResearchQuestion.getNo(), trResearchQuestion.getResearchId());
        	for (TrResearchQuestion question : listAllForJump) {
        		//获取题目相关的附件
                List<String> attachmentUrl = researchQuestionAttachmentMapper.selectQuestionAttachmentByQuestionId(question.getId());
                question.setAttachmentUrl(attachmentUrl);
        	}
        	
            return listAllForJump;
        } 
        return null;
    }


    /**
     * 重置题号
     *
     * @param
     */
//    private void reBuildNo(Long researchId) {
//        // 按题号顺序查出所有未删除的
//        TrResearchQuestion researchQuestion = new TrResearchQuestion();
//        researchQuestion.setResearchId(researchId);
//        researchQuestion.setDeleted(0);
//        EntityWrapper<TrResearchQuestion> ew = new EntityWrapper(researchQuestion);
//        ew.orderBy("no", true);
//        List<TrResearchQuestion> allQuestions = researchQuestionMapper.selectList(ew);
//
//        if (!CollectionUtils.isEmpty(allQuestions)) {
//            for (int i = 0; i < allQuestions.size(); i++) {
//                TrResearchQuestion temp = new TrResearchQuestion();
//                temp.setId(allQuestions.get(i).getId());
//                temp.setNo(i + 1);
//                researchQuestionMapper.updateById(temp);
//            }
//        }
//    }
    @Transactional
    @Override
    public MyQuestion lastAndNext(MyQuestion myQuestion) {
        RequestContext context = myQuestion.getContext();
        Research research = researchMapper.selectById(myQuestion.getResearchId());
        Map<String, Object> map = new HashMap<String, Object>();
        //返回给前端的题目
        TrResearchQuestion trResearchQuestion = new TrResearchQuestion();
        TrResearchAnswer trResearchAnswer = null;
        AnswerQuestionVo answerQuestionVo = myQuestion.getAnswerQuestionVo();
        Integer isFrist = 0;
        try {
            //第一次答题没有answerQuestionVo,删除记录
            if (answerQuestionVo == null) {
                isFrist = 1;
                trResearchAnswerMapper.deleteAnswer(myQuestion.getResearchId(), context.getAccountId());
                Map<String, Object> deleteQuestionMap = new HashMap<String, Object>(4);
                deleteQuestionMap.put("account_id", context.getAccountId());
                deleteQuestionMap.put("research_id", myQuestion.getResearchId());
                trResearchAnswerQuestionMapper.deleteByMap(deleteQuestionMap);
            }
            //先根据调研id以及用户id 查询是否有回答记录，如果没有就添加一条记录
            trResearchAnswer = new TrResearchAnswer();
            trResearchAnswer.setResearchId(myQuestion.getResearchId());
            trResearchAnswer.setAccountId(context.getAccountId());
            trResearchAnswer.setFinish(0);
            trResearchAnswer = trResearchAnswerMapper.selectOne(trResearchAnswer);
        } catch (Exception e) {
            LOG.error("查询answer表记录出错", e);
            return null;
        }
        try {
            if (trResearchAnswer == null) {
                trResearchAnswer = new TrResearchAnswer();
                trResearchAnswer.setResearchId(myQuestion.getResearchId());
                trResearchAnswer.setId(idGenerator.generate());
                trResearchAnswer.setName(research.getName());
                trResearchAnswer.setAccountId(context.getAccountId());
                trResearchAnswer.setStartTime(myQuestion.getStartDate());
                trResearchAnswer.setTerminalType(myQuestion.getTerminaltype());
                trResearchAnswer.setCompanyId(context.getCompanyId());
                trResearchAnswer.setSiteId(context.getSiteId());
                trResearchAnswer.setOrgId(context.getOrgId());
                trResearchAnswer.setCreateById(context.getAccountId());
                trResearchAnswer.setCreateTime(new Date());
                trResearchAnswer.setCreateByName(context.getAccountName());
                trResearchAnswerMapper.insert(trResearchAnswer);

            }
        } catch (Exception e) {
            e.printStackTrace();
            LOG.error("插入TrResearchAnswer记录报错------------", e);
            return null;
        }
       /* //当前题目的题号
        Integer nextNo = 0;
        //上一题和首次不需要删除旧的答案
        if(myQuestion.getNum() == null &&myQuestion.getAnswerQuestionVo()!= null && 1 != myQuestion.getAnswerQuestionVo().getIsLast()){
            nextNo = getNextNo(answerQuestionVo);
            Integer nowNo = researchQuestionMapper.selectById(myQuestion.getAnswerQuestionVo().getQuestionId()).getNo();
            //判断以前的答案中是否有下一题是该题目
            Integer lastNo = getlastNo(myQuestion.getResearchId(), nextNo, context.getAccountId());
            TrResearchQuestion re = researchQuestionMapper.selectOneByNo(lastNo, myQuestion.getResearchId());
            if ( lastNo != 0 && !lastNo.equals(nowNo)) {
                //满足条件删除

                TrResearchAnswerQuestion answerQuestion = new TrResearchAnswerQuestion();
                answerQuestion.setAccountId(context.getAccountId());
                answerQuestion.setQuestionId(re.getId());
                EntityWrapper<TrResearchAnswerQuestion> wrapper = new EntityWrapper<TrResearchAnswerQuestion>(answerQuestion);
                answerQuestion = trResearchAnswerQuestionMapper.selectOne(answerQuestion);
                if(answerQuestion != null) {
                    trResearchAnswerQuestionMapper.delete(wrapper);
                    Map<String, Object> op = new HashMap<String, Object>(3);
                    op.put("answer_question_id", answerQuestion.getId());
                    trResearchAnswerQuestionResultMapper.deleteByMap(op);
                }
            }
        }*/
        //无论下一题或者提交都需要保存当前题目的答案,第一次,上一题进入则跳过
        if (answerQuestionVo != null && answerQuestionVo.getQuestionItems() != null) {
            Long questionId = answerQuestionVo.getQuestionId();
            TrResearchQuestion question = researchQuestionMapper.selectById(questionId);
            TrResearchAnswerQuestion trResearchAnswerQuestion = new TrResearchAnswerQuestion();
            try {
                trResearchAnswerQuestion.setResearchId(myQuestion.getResearchId());
                trResearchAnswerQuestion.setQuestionId(questionId);
                trResearchAnswerQuestion.setAccountId(context.getAccountId());
                trResearchAnswerQuestion = trResearchAnswerQuestionMapper.selectOne(trResearchAnswerQuestion);
                //1.插入tr_research_answer_question
                if (trResearchAnswerQuestion == null) {
                    trResearchAnswerQuestion = new TrResearchAnswerQuestion();
                    trResearchAnswerQuestion.setResearchId(myQuestion.getResearchId());
                    trResearchAnswerQuestion.setQuestionId(questionId);
                    trResearchAnswerQuestion.setAccountId(context.getAccountId());
                    trResearchAnswerQuestion.setId(idGenerator.generate());
                    trResearchAnswerQuestion.setAnswerId(trResearchAnswer.getId());
                    trResearchAnswerQuestion.setCreateById(context.getAccountId());
                    trResearchAnswerQuestion.setCreateByName(context.getAccountName());
                    trResearchAnswerQuestion.setCreateTime(new Date());
                    trResearchAnswerQuestionMapper.insert(trResearchAnswerQuestion);
                } else {
                    //2.更新
                    trResearchAnswerQuestion.setUpdateById(context.getAccountId());
                    trResearchAnswerQuestion.setUpdateByName(context.getAccountName());
                    trResearchAnswerQuestion.setUpdateTime(new Date());
                    trResearchAnswerQuestionMapper.updateById(trResearchAnswerQuestion);
                }
            } catch (Exception e) {
                e.printStackTrace();
                LOG.error("更新或者插入TrResearchAnswerQuestion出错------------", e);
                return null;
            }
            try {
                List<AnswerQuestionItemVo> itemVos = answerQuestionVo.getQuestionItems();
                if (!CollectionUtils.isEmpty(itemVos)) {
                    List<TrResearchAnswerQuestionResult> trResearchAnswerQuestionResults = new ArrayList<TrResearchAnswerQuestionResult>();
                    TrResearchAnswerQuestionResult result;
                    map.put("answer_question_id", trResearchAnswerQuestion.getId());
                    trResearchAnswerQuestionResultMapper.deleteByMap(map);
                    for (AnswerQuestionItemVo itemVo : itemVos) {
                        result = new TrResearchAnswerQuestionResult();
                        result.setId(idGenerator.generate());
                        result.setAnswerQuestionId(trResearchAnswerQuestion.getId());
                        result.setAnswerId(trResearchAnswer.getId());
                        result.setQuestionType(question.getType());
                        result.setContent(itemVo.getContent());
                        result.setOptionId(itemVo.getOptionId());
                        result.setScore(itemVo.getScore());
                        result.setResearchId(myQuestion.getResearchId());
                        result.setCreateById(context.getAccountId());
                        result.setCreateByName(context.getAccountName());
                        result.setCreateTime(new Date());
                        trResearchAnswerQuestionResults.add(result);
                    }
                    if (!CollectionUtils.isEmpty(trResearchAnswerQuestionResults)) {
                        trResearchAnswerQuestionResultMapper.batchInsert(trResearchAnswerQuestionResults);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
                LOG.error("更新或者插入tr_research_answer_question_result出错------", e);
                return null;
            }

            //提交
            try {
                //肯定存在trResearchAnswer, 更新
                if (answerQuestionVo.getIsLast() == 1) {
                    trResearchAnswer.setFinish(1);
                    trResearchAnswer.setSubmitTime(new Date());
                    //trResearchAnswer.setSubmitTime(myQuestion.getEndDate());
                    //trResearchAnswer.setDuration(((int) (myQuestion.getEndDate().getTime() - trResearchAnswer.getStartTime().getTime())) / 1000);
                    trResearchAnswerMapper.updateById(trResearchAnswer);

                    // 向培训项目发送消息，告知业务已经完成
                    EventWrapper<TrainingProjectEvent> eventWrapper = new EventWrapper<TrainingProjectEvent>(myQuestion.getResearchId(), TrainingProjectEvent.getInstance(myQuestion.getResearchId(), TpActivityType.TYPE_RESEARCH, context.getAccountId(), new Date(), context.getSiteId()));
                    LOG.info("向培训项目发送消息，告知业务已经完成:{}", eventWrapper);
                    taskExecutor.asynExecute(new AbstractTaskHandler() {
                        @Override
                        public void handle() {
                            try {
                                cloudEventPublisher.publish(QueueConstant.TRAINING_PROJECT_EVENT_QUEUE, eventWrapper);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });

                    return myQuestion;
                }
            } catch (Exception e) {
                e.printStackTrace();
                LOG.error("提交调研出错-----------", e);
                return null;
            }
        }
        try {
            //返回问题给前端，根据问题编号
            trResearchQuestion = new TrResearchQuestion();
            if (answerQuestionVo == null) {
                trResearchQuestion.setNo(getMinNo(myQuestion.getResearchId()));
            } else {
                //返回下一题
                if (myQuestion.getNum() == null) {
                    trResearchQuestion.setNo(getNextNo(answerQuestionVo));
                    answerQuestionVo = new AnswerQuestionVo();
                } else {
                    trResearchQuestion.setNo(myQuestion.getNum());
                }
            }
            trResearchQuestion.setDeleted(0);
            trResearchQuestion.setResearchId(myQuestion.getResearchId());
            trResearchQuestion = researchQuestionMapper.selectOne(trResearchQuestion);
            if (trResearchQuestion == null) {
                LOG.info("没有找到下一个或上一个题目-------------");
                return null;
            }
            /*trResearchQuestion.setLastNo(getlastNo(trResearchQuestion.getResearchId(),trResearchQuestion.getNo(),context.getAccountId()));*/
            trResearchQuestion.setIsFrist(isFrist);
            Integer minNo = getMinNo(myQuestion.getResearchId());
            if (minNo != null && trResearchQuestion.getNo().equals(minNo)) {
                trResearchQuestion.setRemark(research.getContent());
            }

            if (getMaxNo(myQuestion.getResearchId()) != null && trResearchQuestion.getNo().equals(getMaxNo(myQuestion.getResearchId()))) {
                trResearchQuestion.setIsLast(1);
            }
            TrResearchQuestionOption option = new TrResearchQuestionOption();
            option.setQuestionId(trResearchQuestion.getId());
            option.setDeleted(0);
            List<TrResearchQuestionOption> options = researchQuestionOptionMapper.selectList(new EntityWrapper<TrResearchQuestionOption>(option));
            if (!CollectionUtils.isEmpty(options)) {
                for (TrResearchQuestionOption option1 : options) {
                    if (option1.getIsOther() != null && option1.getIsOther() == 1 && option1.getRequired() != null && option1.getRequired() == 1) {
                        trResearchQuestion.setRequired(1);
                    }
                }
            }
            trResearchQuestion.setOptions(options);
            myQuestion = new MyQuestion();
            //返回题目中，学员可能回答过
            TrResearchAnswerQuestion trResearchAnswerQuestion = new TrResearchAnswerQuestion();
            trResearchAnswerQuestion.setQuestionId(trResearchQuestion.getId());
            trResearchAnswerQuestion.setAccountId(context.getAccountId());
            trResearchAnswerQuestion = trResearchAnswerQuestionMapper.selectOne(trResearchAnswerQuestion);
            List<TrResearchQuestionOption> answerOptions = new ArrayList<>();
            if (trResearchAnswerQuestion != null) {
                answerQuestionVo = new AnswerQuestionVo();
                answerQuestionVo.setAnswerQuestionId(trResearchAnswerQuestion.getId());
                answerQuestionVo.setQuestionId(trResearchQuestion.getId());
                answerQuestionVo.setQuestionType(trResearchQuestion.getType());
                map = new HashMap<String, Object>(6);
                map.put("answer_question_id", trResearchAnswerQuestion.getId());
                List<AnswerQuestionItemVo> questionItems  = Lists.newArrayList();
                List<TrResearchAnswerQuestionResult> trResearchAnswerQuestionResults = trResearchAnswerQuestionResultMapper.selectByMap(map);
                if (!CollectionUtils.isEmpty(options)) {
                    for (TrResearchQuestionOption option1 : options) {
                        if (!CollectionUtils.isEmpty(trResearchAnswerQuestionResults)) {
                            for (TrResearchAnswerQuestionResult result : trResearchAnswerQuestionResults) {
                                //单选多选打分
                                if (option1.getId().equals(result.getOptionId())) {
                                    option1.setCheck(1);
                                    option1.setAnswerScore(result.getScore());
                                    option1.setAnswerContent(result.getContent());
                                    break;
                                }
                            }
                        }
                        answerOptions.add(option1);
                    }
                } else {
                    TrResearchQuestionOption answer = new TrResearchQuestionOption();
                    if (!CollectionUtils.isEmpty(trResearchAnswerQuestionResults)) {
                        answer.setAnswerContent(trResearchAnswerQuestionResults.get(0).getContent());
                    }
                    answerOptions.add(answer);
                }

                if (!CollectionUtils.isEmpty(trResearchAnswerQuestionResults)) {
                    for (TrResearchAnswerQuestionResult result : trResearchAnswerQuestionResults) {
                        AnswerQuestionItemVo itemVo = new AnswerQuestionItemVo();
                        itemVo.setContent(result.getContent());
                        itemVo.setOptionId(result.getOptionId());
                        itemVo.setScore(result.getScore());
                        questionItems.add(itemVo);
                    }
                    answerQuestionVo.setQuestionItems(questionItems);
                }
            }
            if (!CollectionUtils.isEmpty(answerOptions)) {
                trResearchQuestion.setOptions(answerOptions);
            }
            TrResearchQuestionVo trResearchQuestionVo=new TrResearchQuestionVo();
            BeanUtils.copyProperties(trResearchQuestion,trResearchQuestionVo);
            
            //获取题目相关的附件
            Long questionID = trResearchQuestionVo.getId();
            List<String> attachmentUrl = researchQuestionAttachmentMapper.selectQuestionAttachmentByQuestionId(questionID);
            trResearchQuestionVo.setAttachmentUrl(attachmentUrl);
            
            myQuestion.setQuestion(trResearchQuestionVo);
            myQuestion.setAnswerQuestionVo(answerQuestionVo);
            return myQuestion;
        } catch (Exception e) {
            e.printStackTrace();
            LOG.error("返回试题过程中发生错误--------", e);
            return null;
        }
    }

    @Override
    public Integer updateQuestionJump(QuestionJumpVo vo) {
        RequestContext context = vo.getContext();
        List<TrResearchQuestionOptionVo> options = vo.getOptions();
        Long questionId = vo.getQuestionId();
        Integer jumpNo = vo.getJumpNo();
        Integer type = vo.getType();
        Date date = new Date();
        Integer num = 0;
        try {
            if (type == 1 && !CollectionUtils.isEmpty(options)) {
                for (TrResearchQuestionOptionVo option : options) {
                    if (option.getJumpNum() == null) {
                        option.setJumpNum(-1);
                    }
                    option.setUpdateById(context.getAccountId());
                    option.setUpdateByName(context.getAccountName());
                    option.setUpdateTime(date);
                    TrResearchQuestionOption p=new TrResearchQuestionOption();
                    BeanUtils.copyProperties(option,p);
                    researchQuestionOptionMapper.updateById(p);
                }
            }
            TrResearchQuestion question = new TrResearchQuestion();
            question.setId(questionId);
            if (type == 2 && jumpNo == null) {
                question.setJumpNum(-1);
            } else {
                question.setJumpNum(jumpNo);
            }
            question.setJumpType(type);
            question.setUpdateById(context.getAccountId());
            question.setUpdateByName(context.getAccountName());
            question.setUpdateTime(date);
            question.setNo(vo.getNo());
            num = researchQuestionMapper.updateById(question);
        } catch (Exception e) {
            e.printStackTrace();
            LOG.error("更新跳题策略失败", e);
        }
        return num;
    }

    @Override
    public List<Long> getFinishedAccountIds(Long researchId, Long companyId, Long siteId) {
        return researchQuestionMapper.getFinishedAccountIds(researchId, companyId, siteId);
    }


    public Integer checkJump(Long id, Long researchId) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("research_id", researchId);
        map.put("deleted", 0);
        TrResearchQuestion researchQuestion = researchQuestionMapper.selectById(id);
        List<TrResearchQuestion> questions = researchQuestionMapper.selectByMap(map);
        List<TrResearchQuestionOption> options = researchQuestionOptionMapper.selectByMap(map);
        TrResearchQuestion q;
        if (researchQuestion != null && !CollectionUtils.isEmpty(questions)) {
            for (TrResearchQuestion question : questions) {
                if (question.getJumpType() == 2 && question.getJumpNum() != null && question.getJumpNum().equals(researchQuestion.getNo()) && !question.getId().equals(id)) {
                    return 1;
                }
            }
            if (!CollectionUtils.isEmpty(options)) {
                for (TrResearchQuestionOption option : options) {
                    q = researchQuestionMapper.selectById(option.getQuestionId());
                    if (q.getJumpType() == 1 && option.getJumpNum() != null && option.getJumpNum().equals(researchQuestion.getNo())) {
                        return 1;
                    }
                }
            }
        }
        return 0;
    }

    public Integer getNextNo(AnswerQuestionVo answerQuestionVo) {
        Long questionId = answerQuestionVo.getQuestionId();
        TrResearchQuestion question = researchQuestionMapper.selectById(questionId);
        if (question.getJumpType() != null) {
            if (question.getJumpType() == 2 && question.getJumpNum() != null && question.getJumpNum() != -1) {
                return question.getJumpNum();
            } else {
                List<AnswerQuestionItemVo> vo = answerQuestionVo.getQuestionItems();
                if (!CollectionUtils.isEmpty(vo)) {
                    for (AnswerQuestionItemVo item : vo) {
                        if (item.getOptionId() != null) {
                            TrResearchQuestionOption option = researchQuestionOptionMapper.selectById(item.getOptionId());
                            if (option.getJumpNum() != null && option.getJumpNum() != -1) {
                                return option.getJumpNum();
                            }
                        }
                    }
                }
            }
        }
        TrResearchQuestion q = new TrResearchQuestion();
        q.setResearchId(question.getResearchId());
        q.setDeleted(0);
        EntityWrapper<TrResearchQuestion> wrapper = new EntityWrapper<TrResearchQuestion>(q);
        wrapper.orderBy("no", true);
        List<TrResearchQuestion> questions = researchQuestionMapper.selectList(wrapper);
        for (TrResearchQuestion question1 : questions) {
            if (question1.getNo() > question.getNo()) {
                return question1.getNo();
            }
        }
        return question.getNo();
    }

    public Integer getMinNo(Long researchId) {
        TrResearchQuestion question = new TrResearchQuestion();
        question.setResearchId(researchId);
        question.setDeleted(0);
        EntityWrapper<TrResearchQuestion> wrapper = new EntityWrapper<TrResearchQuestion>(question);
        wrapper.orderBy("no", true);
        List<TrResearchQuestion> questions = researchQuestionMapper.selectList(wrapper);
        if (!CollectionUtils.isEmpty(questions)) {
            question = questions.get(0);
            return question.getNo();
        }
        return null;
    }

    public Integer getMaxNo(Long researchId) {
        TrResearchQuestion question = new TrResearchQuestion();
        question.setResearchId(researchId);
        question.setDeleted(0);
        EntityWrapper<TrResearchQuestion> wrapper = new EntityWrapper<TrResearchQuestion>(question);
        wrapper.orderBy("no", true);
        List<TrResearchQuestion> questions = researchQuestionMapper.selectList(wrapper);
        if (!CollectionUtils.isEmpty(questions)) {
            Integer index = questions.size() - 1;
            question = questions.get(index);
            return question.getNo();
        }
        return null;

    }
    /*public Integer getlastNo(Long researchId,Integer no,Long accountId){
        List<TrResearchQuestion> questions = trResearchAnswerQuestionMapper.selectListByAnswer(researchId,accountId);
        if(!CollectionUtils.isEmpty(questions)){
            for(TrResearchQuestion question : questions){
                if(question.getJumpType() != null &&question.getJumpType()==2 && question.getJumpNum()!= null && question.getJumpNum() .equals(no)){
                    return question.getNo();
                }
            }
        }
        TrResearchAnswer answer = new TrResearchAnswer();
        answer.setResearchId(researchId);
        answer.setAccountId(accountId);
        answer.setFinish(0);
        answer = trResearchAnswerMapper.selectOne(answer);
        if(answer == null){
            return 0;
        }
        List<TrResearchQuestionOption> options = researchQuestionOptionMapper.selectByAnswer(answer.getId());
        if(!CollectionUtils.isEmpty(options)){
            for(TrResearchQuestionOption option :options){
                if(option.getJumpNum()!=null && option.getJumpNum() .equals(no)){
                    return researchQuestionMapper.selectByOptionId(option.getId());
                }
            }
        }
        TrResearchQuestion question = new TrResearchQuestion();
        question.setResearchId(researchId);
        question.setDeleted(0);
        EntityWrapper<TrResearchQuestion> wrapper = new EntityWrapper<TrResearchQuestion>(question);
        wrapper.orderBy("no",false);
        List<TrResearchQuestion> questionList = researchQuestionMapper.selectList(wrapper);
        if(!CollectionUtils.isEmpty(questionList)){
            for(TrResearchQuestion question1 :questionList){
                if(question1.getNo()<no){
                    return question1.getNo();
                }
            }
        }
        return 0;
    }*/
    /*public void deleteAnswer(Integer startNo , Integer endNo, Long accountId, Long researchId){
        List<Long> questionIds = researchQuestionMapper.selectQuestion(startNo,endNo,researchId);
        List<Long> answerQuestionId = trResearchAnswerQuestionMapper.selectAnswerQuestionId(startNo,endNo,accountId);

    }*/

    private Integer[] buildJumpedNums(Integer current, Integer dest) {
        if (null == current || null == dest) {
            return null;
        }
        if (current > dest) {
            int temp = dest;
            dest = current;
            current = temp;
        }
        Integer[] arrs = new Integer[dest - current - 1];
        for (int i = 1; i + current < dest; i++) {
            arrs[i - 1] = current + i;
        }
        System.out.println(Arrays.toString(arrs));
        return arrs;
    }

    private Integer getMaxNo(List<TrResearchQuestion> questions) {
        if (CollectionUtils.isEmpty(questions)) {
            return 0;
        } else {
            int maxNo = 0;
            TrResearchQuestion question;
            for (int i = 0; i < questions.size(); i++) {
                question = questions.get(i);
                if (question != null && question.getDeleted() == 0 && maxNo < question.getNo()) {
                    maxNo = question.getNo();
                }
            }
            return maxNo;
        }
    }
    //获取当前题号和题目的对应关系
    public Map<Integer,Long> getCurrentQuestion(List<TrResearchQuestion> questions){
        Map<Integer ,Long> noToQuestion = new HashMap<Integer, Long>();
        for(TrResearchQuestion question :questions){
            noToQuestion.put(question.getNo(),question.getId());
        }
        return noToQuestion;
    }
    //获取题目跳向当前题号的题目
    public Map<Integer,List<Long>> getNoToQuestions(List<TrResearchQuestion> questions){
        Map<Integer,List<Long>> noToQuestions =new HashMap<Integer, List<Long>>();
        Integer no ;
        List<Long> questionIds;
        for(TrResearchQuestion question :questions){
            no = question.getNo();
            for(TrResearchQuestion q : questions){
                if((q.getJumpType() == 2 && no.equals(q.getJumpNum()))){
                    if(noToQuestions.get(no) == null){
                        questionIds = new ArrayList<Long>();
                    }else{
                        questionIds = noToQuestions.get(no);
                    }
                    questionIds.add(q.getId());
                    noToQuestions.put(no,questionIds);
                }
            }
        }
        return noToQuestions;
    }
    //获取选项跳向当前题号的题目
    public Map<Integer,List<Long>> getNoToOptions(List<TrResearchQuestionOption> options,List<TrResearchQuestion> questions){
        Map<Integer,List<Long>> noToOptions = new HashMap<Integer, List<Long>>();
        Integer no;
        List<Long> optionIds;
       // Integer qno;
        for(TrResearchQuestion question :questions) {
            no = question.getNo();
            for(TrResearchQuestionOption option : options){
               // qno = optionToQuestion.get(option.getId());
                if(no.equals(option.getJumpNum())){
                    if(noToOptions.get(no) == null){
                        optionIds = new ArrayList<Long>();
                    }else{
                        optionIds = noToOptions.get(no);
                    }
                    optionIds.add(option.getId());
                    noToOptions.put(no,optionIds);
                }
            }
        }
        return noToOptions;
    }

	@Override
	public VoteRankingVo getVoteResult(Long researchId, Integer pageNo, Integer pageSize) {
        if(pageNo == null) {
            pageNo = 1;
        }
        if(pageSize == null) {
            pageSize = Integer.MAX_VALUE;
        }
		RequestContext context = ContextHolder.get();
		Long companyId = context.getCompanyId();
		Long siteId = context.getSiteId();
        LOG.info("投票列表入参, companyId:{}, siteId:{}, researchId:{}, start:{}, range:{}", companyId, siteId, researchId, (pageNo - 1) * pageSize, pageSize);
		VoteRankingVo voteRankingVo = researchQuestionMapper.getVoteResult(companyId, siteId, researchId, context.getAccountId(),(pageNo - 1) * pageSize , pageSize);
        //LOG.info("投票列表返回, voteRankingVo:{}", JSONUtil.toJsonStr(voteRankingVo));
        if(voteRankingVo != null){
			Integer finish = trResearchAnswerMapper.getResearchAnsweFinish(context.getAccountId(), researchId);
			if(finish != null && finish == 1){
				voteRankingVo.setVoteNum(0);
			}
            if(!CollectionUtils.isEmpty(voteRankingVo.getRankingList())) {
                Research research = researchMapper.selectById(researchId);
                if(research != null) {
                    voteRankingVo.getRankingList().forEach(v -> {
                           v.setStyleType(research.getStyleType());
                    });
                }
            }
		}
		return voteRankingVo;
	}

	@Override
	public VoteRankingVo getVoteTop(Long researchId) {
		RequestContext context = ContextHolder.get();
		Long companyId = context.getCompanyId();
		Long siteId = context.getSiteId();
		VoteRankingVo result = researchQuestionMapper.getVoteTop(companyId, siteId, researchId);
		if(result != null && !CollectionUtils.isEmpty(result.getRankingList())){
			int no = 1;
			for(VoteRankingListVo item : result.getRankingList()){
				item.setNo(no++);
			}
		}
		return result;
	}

    @Override
    public int deleteByResearchIdAndQueId(Long queId, Long researchId) {
        researchQuestionMapper.deleteByResearchIdAndQueId(queId, researchId);
       return researchQuestionOptionMapper.deleteByResearchIdAndQueId(queId, researchId);
    }
}
