package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@Api(tags = "StatisticsResearch", description = "")
@TableName("statistics_research_metadata")
public class StatisticsResearch {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value="id", type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "调研ID")
    @TableField("research_id")
    private Long researchId;

    @ApiModelProperty(value = "调研编码")
    @TableField("research_no")
    private String researchNo;

    @ApiModelProperty(value = "调研名称")
    @TableField("research_name")
    private String researchName;

    @ApiModelProperty(value = "调研开始时间")
    @TableField("research_start_time")
    private Date researchStartTime;

    @ApiModelProperty(value = "调研结束时间")
    @TableField("research_end_time")
    private Date researchEndTime;

    @ApiModelProperty(value = "创建调研的企业ID")
    @TableField("research_company_id")
    private Long researchCompanyId;

    @ApiModelProperty(value = "创建调研的站点ID")
    @TableField("research_site_id")
    private Long researchSiteId;

    @ApiModelProperty(value = "创建调研的组织ID")
    @TableField("research_org_id")
    private Long researchOrgId;

    @ApiModelProperty(value = "调研创建时间")
    @TableField("research_create_time")
    private Date researchCreateTime;

    @ApiModelProperty(value = "用户ID")
    @TableField("account_id")
    private Long accountId;

    @ApiModelProperty(value = "用户名")
    @TableField("account_name")
    private String accountName;

    @ApiModelProperty(value = "用户姓名")
    @TableField("account_fullname")
    private String accountFullName;

    @ApiModelProperty(value = "用户状态")
    @TableField("account_state")
    private Integer accountState;

    @ApiModelProperty(value = "工号")
    @TableField("account_work_num")
    private String accountWorkNum;
    
    @ApiModelProperty(value = "学员企业ID")
    @TableField("account_company_id")
    private Long accountCompanyId;

    @ApiModelProperty(value = "学员企业ID")
    @TableField("account_site_id")
    private Long accountSiteId;

    @ApiModelProperty(value = "学员组织ID")
    @TableField("account_org_id")
    private Long accountOrgId;

    @ApiModelProperty(value = "所在部门")
    @TableField("org_name")
    private String orgName;

    @ApiModelProperty(value = "部门所有父节点名称")
    @TableField("org_parent_names")
    private String orgParentNames;

    @ApiModelProperty(value = "应参加状态，1应参加 0不应参加（用于统计：应参加人数，MAX取值）")
    @TableField("can_state")
    private Integer canState;

    @ApiModelProperty(value = "应参加人数")
    @TableField(exist = false)
    private Integer canStateCount;

    @ApiModelProperty(value = "实际参加状态，1参加 0未参加（用于统计：实参加人数，MAX取值）")
    @TableField("join_state")
    private Integer joinState;

    @ApiModelProperty(value = "实际参加人数")
    @TableField(exist = false)
    private Integer joinStateCount;

    @ApiModelProperty(value = "调研完成时间")
    @TableField(exist = false)
    private Date finishTime;

    @ApiModelProperty(value = "调研序号")
    @TableField(exist = false)
    private Integer index;

}
