package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 答卷
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "TrResearchAnswer", description = "答卷")
@TableName("tr_research_answer")
public class TrResearchAnswer extends Model<TrResearchAnswer> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "答卷ID，主键")
    @TableId("id")
    private Long id;

    @ApiModelProperty(value = "调研主键_ID，外键")
    @TableField("research_id")
    private Long researchId;

    @ApiModelProperty(value = "调研名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "学员_ID")
    @TableField("account_id")
    private Long accountId;

    @ApiModelProperty(value = "开始时间，用户进入考试的时间")
    @TableField("start_time")
    private Date startTime;

    @ApiModelProperty(value = "提交时间")
    @TableField("submit_time")
    private Date submitTime;

    @ApiModelProperty(value = "调研用时，分钟")
    @TableField("duration")
    private Integer duration;

    @ApiModelProperty(value = "调研终端类型，1微信 2PC 3APP")
    @TableField("terminal_type")
    private Integer terminalType;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "企业_ID")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "部门_ID")
    @TableField("org_id")
    private Long orgId;

    @ApiModelProperty(value = "站点_ID")
    @TableField("site_id")
    private Long siteId;
    
    @ApiModelProperty(value = "是否完成 1：已完成(默认) 0：未完成  2：已删除")
    @TableField("finish")
    private Integer finish;

    @ApiModelProperty(value = "该调研答卷下关联的问题，不持久化")
    @TableField(exist = false)
    private List<TrResearchAnswerQuestion> answerQuestions;




    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
