package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 答案选项
 * </p>
 *
 * @author shengchenglong123
 * @since 2018-03-19
 */
@Data
@Api(tags = "TrResearchQuestionResult", description = "答案选项")
@TableName("tr_research_answer_question_result")
public class TrResearchAnswerQuestionResult extends Model<TrResearchAnswerQuestionResult> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "答案ID，主键")
    @TableId("id")
	private Long id;

    @ApiModelProperty(value = "冗余调研id")
	@TableField("research_id")
	private Long researchId;

	@ApiModelProperty(value = "冗余answerId")
	@TableField("answer_id")
	private Long answerId;

    @ApiModelProperty(value = "答案题目_ID，外键")
	@TableField("answer_question_id")
	private Long answerQuestionId;

    @ApiModelProperty(value = "问题类型，1单选题、2多选题、3问答题、4打分题")
	@TableField("question_type")
	private Integer questionType;

    @ApiModelProperty(value = "单选题和多选题，存放问题选中选项的ID")
	@TableField("option_id")
	private Long optionId;

    @ApiModelProperty(value = "问答题，存放回答内容（question_type=3）")
	@TableField("content")
	private String content;

    @ApiModelProperty(value = "打分题，学员给的分值")
	@TableField("score")
	private Integer score;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "创建人ID")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

    @ApiModelProperty(value = "创建人姓名")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

    @ApiModelProperty(value = "修改时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
