package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 调研用户范围
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "TrResearchAuthorize", description = "调研用户范围")
@TableName("tr_research_authorize")
public class TrResearchAuthorize extends Model<TrResearchAuthorize> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    @TableId("id")
    private Long id;

    @ApiModelProperty(value = "调研主键_ID，外键")
    @TableField("research_id")
    private Long researchId;

    @ApiModelProperty(value = "1. 部门，2.用户，3.用户组")
    @TableField("type")
    private Integer type;

    @ApiModelProperty(value = "关联id，类型由type判定")
    @TableField("relation_id")
    private Long relationId;

    @ApiModelProperty(value = "所属站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "状态，0删除 1有效（默认有效）")
    @TableLogic
    private Integer state;
    
    @ApiModelProperty(value = "关联人员名称")
    @TableField(value = "name")
    private String name;


    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "用户名")
    @TableField(exist = false)
    private String fullName;

    @ApiModelProperty(value = "工号")
    @TableField(exist = false)
    private String workNum;
    
   

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
