package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 只对题型是：单选题、多选题和打分题
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "TrResearchQuestionOption", description = "只对题型是：单选题、多选题和打分题")
@TableName("tr_research_question_option")
public class TrResearchQuestionOption extends Model<TrResearchQuestionOption> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "选项ID主键")
    @TableId("id")
    private Long id;

    @ApiModelProperty(value = "所属调研，冗余字段")
    @TableField("research_id")
    private Long researchId;

    @ApiModelProperty(value = "问题主键_ID，外键")
    @TableField("question_id")
    private Long questionId;

    @ApiModelProperty(value = "问题类型，1单选题、2多选题、3问答题、4打分题")
    @TableField("question_type")
    private Integer questionType;

    @ApiModelProperty(value = "选项排序，不能为空")
    @TableField("no")
    private Integer no;

    @ApiModelProperty(value = "允许填空，对单选和多选有效，0不允许 1允许，默认0")
    @TableField("editable")
    private Integer editable;

    @ApiModelProperty(value = "是否是必填 0 不是 1是")
    @TableField("required")
    private Integer required;

    @ApiModelProperty(value = "是否是其他选项 0不是 1 是")
    @TableField("isOther")
    private Integer isOther;

    @ApiModelProperty(value = "选项内容，最多支持输入500汉字")
    @TableField("content")
    private String content;

    @ApiModelProperty(value = "最低分值（打分题有效），只对打分题有效")
    @TableField("min_score")
    private Integer minScore;

    @ApiModelProperty(value = "最高分值（打分题有效），只对打分题有效")
    @TableField("max_score")
    private Integer maxScore;

    @ApiModelProperty(value = "跳题题号（单选题有效），问题设置了跳题才有效，大于当前题号")
    @TableField("jump_num")
    private Integer jumpNum;

    @ApiModelProperty(value = "指定跳题时才有效，越过的题号")
    @TableField(exist = false)
    private Integer[] jumpedNums;

    @ApiModelProperty(value = "是否正确答案（选择题有效），0不是 1是默认不是")
    @TableField("correct")
    private Integer correct;

    @ApiModelProperty(value = "是否删除（0：未删，1：已删）")
    @TableField("deleted")
    private Integer deleted;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "是否被选中 1选中，0没有选中")
    @TableField(exist = false)
    private Integer check = 0;

    @ApiModelProperty(value = "问答题 回答内容")
    @TableField(exist = false)
    private String answerContent;

    @ApiModelProperty(value = "打分题 分数")
    @TableField(exist = false)
    private Integer answerScore;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
