package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 提醒时间
 * </p>
 *
 * @author shengchenglong123
 * @since 2018-03-14
 */
@Data
@Api(tags = "TrResearchRemind", description = "提醒时间")
@TableName("tr_research_remind")
public class TrResearchRemind extends Model<TrResearchRemind> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键id")
    @TableId("id")
	private Long id;

    @ApiModelProperty(value = "关联调研id")
	@TableField("research_id")
	private Long researchId;

	@ApiModelProperty(value = "1：开始之前，2：开始之后，3：自定义时间")
	@TableField("type")
	private Integer type;

	@ApiModelProperty(value = "type=1或type=2：相差秒数")
	@TableField("seconds")
	private Long seconds;

	@ApiModelProperty(value = "是否删除（0：未删，1：已删）")
	@TableField("deleted")
	private Integer deleted;

    @ApiModelProperty(value = "提醒时间")
	@TableField("time")
	private Date time;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "创建人ID")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

    @ApiModelProperty(value = "创建人姓名")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
