package com.yizhi.research.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.research.application.model.AnswerModel;
import com.yizhi.research.application.vo.StatisticResearchMetadataVo;
import com.yizhi.research.application.vo.api.ViewAnswerVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/19 10:31
 */
@FeignClient(name = "research", contextId = "ResearchAnswerClient")
public interface ResearchAnswerClient {

    /**
     * 学员提交调研问卷答案
     *
     * @param answerModel
     * @return
     */
    @PostMapping("/researchAnswer/submit")
    Integer submitAnswer(@RequestBody AnswerModel answerModel);

    /**
     * 查看提交的问卷答案
     *
     * @param researchId
     * @param accountId
     * @return
     */
    @GetMapping("/researchAnswer/view")
    ViewAnswerVo viewResearch(@RequestParam("researchId") Long researchId, @RequestParam("accountId") Long accountId);

    @GetMapping("/researchAnswer/views")
    Page<ViewAnswerVo> viewAnswers(@RequestParam("researchId") Long researchId,
                                   @RequestParam("pageNo") Integer start,
                                   @RequestParam("pageSize") Integer end);

    @GetMapping("/researchAnswer/view/list")
    List<ViewAnswerVo> viewList(@RequestParam("researchId") Long researchId);

    @GetMapping("/researchAnswer/views/list")
    List<ViewAnswerVo> viewAnswersList(@RequestParam("researchId") Long researchId,
                                       @RequestParam("pageNo") Integer pageNo,
                                       @RequestParam("pageSize") Integer pageSize);
    @GetMapping("/researchAnswer/views/count")
    Integer viewAnswersCount(@RequestParam("researchId") Long researchId);

    @GetMapping("/researchAnswer/selectLearnRecord")
    public List<StatisticResearchMetadataVo> selectLearnRecord(@RequestParam("researchId")Long researchId,
                                                               @RequestParam("startDate")String startDate,
                                                               @RequestParam("endDate")String endDate);


}
