package com.yizhi.research.application.feign;

import com.yizhi.research.application.vo.domain.TrResearchAuthorizeVo;
import com.yizhi.research.application.vo.VisibleRangeExport;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/6/8 13:36
 */
@FeignClient(name = "research", contextId = "ResearchAuthorizeClient")
public interface ResearchAuthorizeClient {

    /**
     * 查看可见范围
     *
     * @param researchId
     * @return
     */
    @GetMapping("/researchAuthorize/researchId/get")
    List<TrResearchAuthorizeVo> getResearchAuthorize(@RequestParam("researchId") Long researchId);

    @PostMapping("/researchAuthorize/researchId/insert")
    Boolean insertResearchAuthorize(@RequestBody List<TrResearchAuthorizeVo> trResearchAuthorizeVos);
    
    /**
	  * 可见范围导出
	  * @param assignmentId
	  * @return
	  */
	 @GetMapping("/researchAuthorize/export/visiblRange")
	 public VisibleRangeExport exportVisibleRange(@RequestParam(name="researchId",required=true)Long researchId);

}
