package com.yizhi.research.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.research.application.vo.CalendarTaskParamVo;
import com.yizhi.research.application.vo.domain.ResearchVo;
import com.yizhi.research.application.model.CopyResearchModel;
import com.yizhi.research.application.vo.BaseModel;
import com.yizhi.research.application.vo.api.CheckResearchStateVo;
import com.yizhi.research.application.vo.api.PageVo;
import com.yizhi.research.application.vo.api.SearchVo;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/13 14:26
 */
@FeignClient(name = "research", contextId = "ResearchClient")
public interface ResearchClient {

    /**
     * 返回插入的调研的 id
     *
     * @param researchVo
     * @return
     */
    @PostMapping("/research/insert")
    ResearchVo insert(@RequestBody ResearchVo researchVo);

    /**
     * 分页查询
     *
     * @param model
     * @return
     */
    @GetMapping("/research/page/list")
    Page<ResearchVo> listPage(@RequestBody BaseModel<Page<ResearchVo>> model);

    @GetMapping("/research/page/poolExamList")
    Page<Map<String, Object>> getPoolExamList(@RequestParam(value = "name", required = false) String name,
                                              @RequestParam(value = "ids", required = false) List<Long> ids,
                                              @RequestParam(value = "pageNo", required = false) Integer pageNo,
                                              @RequestParam(value = "pageSize", required = false) Integer pageSize);

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @PostMapping("/research/batch/delete")
    Integer batchDelete(@RequestBody List<Long> ids);

//    /**
//     * 上架或下架
//     *
//     * @param id
//     * @param state 1：上架，2：下架
//     * @return
//     */
//    @PostMapping("/research/upOrDown")
//    Integer upOrDown(@RequestParam("id") Long id, @RequestParam("state") Integer state);

    /**
     * 查看一个调研，包含提醒
     *
     * @param id
     * @return
     */
    @GetMapping("/research/view")
    ResearchVo viewOne(@RequestParam("id") Long id);

    /**
     * 更新一个调研，包含提醒（删除以前的提醒）
     *
     * @param researchVo
     * @return
     */
    @PostMapping("/research/update")
    int update(@RequestBody ResearchVo researchVo);

    /**
     * 上架或下架
     *
     * @param researchVo
     * @return
     */
    @PostMapping("/research/release")
    ResearchVo upOrDown(@RequestBody ResearchVo researchVo);

    /**
     * 复制调研
     *
     * @param model
     * @return
     */
    @PostMapping("/research/copy")
    ResearchVo copy(@RequestBody CopyResearchModel model);

    /**
     * 学员端分页列表
     *
     * @param pageVo
     * @return
     */
    @GetMapping("/research/api/page/list")
    Page<ResearchVo> apiListPage(@RequestBody BaseModel<PageVo> model);

    /**
     * 学员端模糊查询分页列表
     *
     * @param searchVo
     * @return
     */
    @GetMapping("/research/api/search/page/list")
    Page<ResearchVo> apiSearchPage(@RequestBody SearchVo searchVo);


    /**
     * 学员端查询我的调研个数
     *
     * @return
     */
    @GetMapping("/research/api/count")
    Integer searchUnfinishCount(@RequestBody RequestContext context);

    /**
     * 检查学员的某个调研的状态
     *
     * @return
     */
    @PostMapping("/research/state/check")
    Integer checkResearchState(@RequestBody CheckResearchStateVo checkResearchStateVo);

    @PostMapping("/research/state/checkTPlan")
    Integer checkTPlanResearchState(@RequestBody CheckResearchStateVo checkResearchStateVo);


    /**
     * 获取管理端报表列表
     *
     * @param startDate
     * @param endDate
     * @param kwd
     * @param pageSize
     * @param pageNo
     * @return
     */
    @GetMapping("/research/group")
    Page<ResearchVo> getResearchList(@RequestParam(name = "startDate", required = false) String startDate, @RequestParam(name = "endDate", required = false) String endDate,
                                     @RequestParam(name = "kwd", required = false) String kwd, @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
                                     @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo, @RequestParam(name = "orgIds", required = false) List<Long> orgIds,
                                     @RequestParam(name = "companyId", required = true) Long companyId, @RequestParam(name = "siteId", required = true) Long siteId
    );

    /**
     * 某个调研的人员完成情况
     *
     * @param researchId
     * @return
     */
    @GetMapping("/research/group/view")
    ResearchVo getResearchView(@RequestParam(name = "researchId", required = true) Long researchId);
    
    
    @GetMapping("/research/by/new/server")
    public List<Map<String, Object>> getServerByCompanyIdAndIds(@RequestParam("companyId")Long companyId,@RequestParam(name="ids",required=false)List<Long> ids);

    @PostMapping("/research/delete")
    public Integer delete(Map map);

    @GetMapping("/research/getAllResearch")
    public List<ResearchVo> getAllResearch();

    @GetMapping("/research/selectRecordMinTime")
    public Date selectRecordMinTime();

    @GetMapping ("/research/getAllSiteId")
    public List<Long> getAllSiteId();

    /**
     * 根据调研id 返回对应的积分
     * @param ids
     * @return
     */
    @GetMapping("/research/getPointById")
    public Integer getPointByIds(@RequestParam(value = "ids",required = false) List<Long> ids);

    @PostMapping("/research/getPageToCalendar")
    public Page<ResearchVo> getPageToCalendar(@ApiParam("paramVo") @RequestBody CalendarTaskParamVo paramVo);

    @GetMapping("/research/getPageByDrools")
    Page<DroolsVo> getPageByDrools(@RequestParam("field") String field,
                                   @RequestParam(value = "value", required = false) String value,
                                   @RequestParam("pageNo") Integer pageNo,
                                   @RequestParam("pageSize") Integer pageSize);
    
    /**
     * 查看一个调研信息
     *
     * @param id
     * @return
     */
    @GetMapping("/research/info")
    ResearchVo viewInfo(@RequestParam("id") Long id);
    
    /**
     * 获取置顶的调研信息
     * @param bizType
     * @return
     */
    @GetMapping("/research/top/get")
    List<ResearchVo> getResearchTop(@RequestParam(value = "bizType", required = false) Integer bizType);
    
    /**
     * 查看研信详情
     *
     * @param id
     * @return
     */
    @GetMapping("/research/details")
    ResearchVo getResearchDetails(@RequestParam("id") Long id);
}
    
    
