package com.yizhi.research.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.research.application.vo.domain.TrResearchQuestionVo;
import com.yizhi.research.application.vo.domain.VoteRankingVo;
import com.yizhi.research.application.model.ModifyQuestionModel;
import com.yizhi.research.application.vo.api.MyQuestion;
import com.yizhi.research.application.vo.api.QuestionJumpVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/14 15:19
 */
@FeignClient(name = "research", contextId = "ResearchQuestionClient")
public interface ResearchQuestionClient {

    /**
     * 批量插入问题
     *
     * @param questions
     * @return
     */
    @PostMapping("/researchQuestion/batch/insert")
    int batchInsert(@RequestBody List<TrResearchQuestionVo> questions);

    /**
     * 问题更新
     *
     * @param modifyQuestionModel 删除的序号，所有的问题（包括没变的，新增的，修改的）
     * @return
     */
    @PostMapping("/researchQuestion/update")
    int batchUpdate(@RequestBody ModifyQuestionModel modifyQuestionModel);


    @PostMapping("/researchQuestion/updateNo")
    int updateNo(@RequestBody QuestionJumpVo vo);

    /**
     * 分页查询 一个调研下面的问题
     *
     * @param page 只有一个
     * @return
     */
    @GetMapping("/researchQuestion/page/list")
    List<TrResearchQuestionVo> listPage(@RequestBody Page<TrResearchQuestionVo> page);

    /**
     * 根据调研id查询所有
     *
     * @param researchId
     * @return
     */
    @GetMapping("/researchQuestion/list")
    List<TrResearchQuestionVo> listAll(@RequestParam("researchId") Long researchId);

    @GetMapping("/researchQuestion/listByPage")
    List<TrResearchQuestionVo> listByPage(
            @RequestParam(value = "pageSize", required = false) Integer pageSize,
            @RequestParam(value = "pageNo", required = false) Integer pageNo,
            @RequestParam("researchId") Long researchId);

    /**
     * 选择跳题时的问题列表
     *
     * @param id 需要跳题的问题id
     * @return
     */
    @GetMapping("/researchQuestion/jump/question/list")
    List<TrResearchQuestionVo> listAllForJump(@RequestParam("id") Long id);

    /**
     * 调研逐题显示下一题或者上一题
     */
    @GetMapping("/researchQuestion/last/next")
    MyQuestion lastAndNext(
            @RequestBody MyQuestion myQuestion
    );

    @PostMapping("/researchQuestion/jump/question/update")
    Integer updateQuestionJump(@RequestBody QuestionJumpVo vo);

    @GetMapping("/researchQuestion/option/get")
    Map<String,Object> getOptionByQuestionId(@RequestParam("questionId") Long id);

    @GetMapping("/researchQuestion/list/all")
    List<TrResearchQuestionVo> list(@RequestParam("researchId") Long researchId);

    @GetMapping("/researchQuestion/getFinishedAccountIds")
    List<Long> getFinishedAccountIds(@RequestParam("researchId") Long researchId,@RequestParam("companyId") Long companyId,@RequestParam("siteId")Long siteId);

    /**
     * 获取投票结果
     * @param researchId
     * @return
     */
    @GetMapping("/researchQuestion/getVoteResult")
    VoteRankingVo getVoteResult(@RequestParam("researchId") Long researchId,
                                @RequestParam(value = "pageNo", required = false) Integer pageNo,
                                @RequestParam(value = "pageSize", required = false) Integer pageSize);
    
    /**
     * 获取投票排行榜
     * @param researchId
     * @return
     */
    @GetMapping("/researchQuestion/getVoteTop")
    VoteRankingVo getVoteTop(@RequestParam("researchId") Long researchId);

    /**
     * 刪除投票中的問題
     * @param id
     * @param researchId
     */
    @GetMapping("/researchQuestion/deleteByResearchIdAndQueId")
    int deleteByResearchIdAndQueId(@RequestParam("id") Long id, @RequestParam("researchId") Long researchId);
}
