package com.yizhi.research.application.vo.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/19 11:03
 */
@Data
@Api(tags = "AnswerQuestionVo", description = "调研问卷答案问题vo")
public class AnswerQuestionVo {

    @ApiModelProperty(value = "问题id 新增不穿，更新必传", required = true)
    private Long questionId;

    @ApiModelProperty(value = "是否是第一题 1是")
    private Integer isFrist =0;

    @ApiModelProperty(value = "是否是最后一题 1是")
    private Integer isLast =0;

    @ApiModelProperty(value = "问题类型，1单选题、2多选题、3问答题、4打分题", required = true)
    private Integer questionType;

    @ApiModelProperty(value = "每个问题的答案vo，多选题和打分题可能会有多个", required = true)
    private List<AnswerQuestionItemVo> questionItems;

    @ApiModelProperty(value = "回答题目的id")
    private Long answerQuestionId;

}
