package com.yizhi.research.application.vo.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/5/8 09:43
 */
@ApiModel("查看提交的问卷答案--答案下的问题")
@Data
public class ViewAnswerQuestionVo {

    @ApiModelProperty(value = "问题_ID")
    private Long id;

    @ApiModelProperty(value = "题号")
    private Integer no;

    @ApiModelProperty(value = "问题类型，1单选题、2多选题、3问答题、4打分题")
    private Integer type;

    @ApiModelProperty(value = "问题内容")
    private String content;

    @ApiModelProperty(value = "存放附件路径，附件格式：音频、视频、图片")
    private String contentAppendixUrl;

    @ApiModelProperty(value = "是否必答，0非必答 1必答，默认0")
    private Integer needAnswer;

    @ApiModelProperty(value = "多选题：最多选择几项，0不选中 >0选中，默认0")
    private Integer maxSelectItem;

    @ApiModelProperty(value = "多选题：最少选择几项，0不选中 >0选中，默认0")
    private Integer minSelectItem;

    @ApiModelProperty(value = "答案下的问题选项集合", notes = "选择题、打分题有效")
    private List<ViewAnswerQuestionOptionVo> options;

    @ApiModelProperty(value = "问答题的回答内容")
    private String answerContent;

    @ApiModelProperty(value = "该问题有效回答的个数")
    private Integer validCount = 0;

    @ApiModelProperty(value = "用户id")
    private Long accountId;
}
