package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.yizhi.research.application.vo.MessageRemindVo;
import com.yizhi.research.application.vo.manage.RemindVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 调研
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "ResearchVo", description = "调研")
@TableName("resarch")
public class ResearchVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "调研主键ID，主键")
    
    private Long id;

    @ApiModelProperty(value = "培训项目ID")
    
    private Long trainingProjectId;

    @ApiModelProperty(value = "调研编码，系统将自动生成调研编码；编码规则，按创建顺序累加，例如DY000001，DY000002")
    
    private String researchNo;

    @ApiModelProperty(value = "积分，默认0")
    
    private Integer point;

    @ApiModelProperty(value = "提醒设置，0否 1是，默认0")
    
    private Integer remind;

    @ApiModelProperty(value = "开启邮件提醒（0：否，1是，默认否）")
    
    private Integer enableMailRemind;

    @ApiModelProperty(value = "邮件提醒，模板id")
    
    private Long mailTemplateId;

    @ApiModelProperty(value = "开启站内提醒（0：否，1是，默认否）")
    
    private Integer enableAppRemind;

    @ApiModelProperty(value = "站内消息提醒模板id")
    
    private Long appTemplateId;

    @ApiModelProperty(value = "调研名称")
    
    private String name;

    @ApiModelProperty(value = "开始时间")
    
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    
    private Date endTime;

    @ApiModelProperty(value = "可见范围，1平台用户可见（企业下所有人员） 2指定学员可见")
    
    private Integer visibleRange;

    @ApiModelProperty(value = "调研说明")
    
    private String content;

    @ApiModelProperty(value = "调研备注")
    
    private String remark;

    @ApiModelProperty(value = "状态，0草稿 1上架 2下架")
    
    private Integer state;

    @ApiModelProperty(value = "删除状态：0未删，1已删（默认0）")
    
    private Integer deleted;

    @ApiModelProperty(value = "创建时间")
    
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    
    private String updateByName;

    @ApiModelProperty(value = "下架时间")
    
    private Date unReleaseTime;

    @ApiModelProperty(value = "下架人ID")
    
    private Long unReleaseById;

    @ApiModelProperty(value = "下架人姓名")
    
    private String unReleaseByName;

    @ApiModelProperty(value = "发布时间")
    
    private Date releaseTime;

    @ApiModelProperty(value = "发布人ID")
    
    private Long releaseById;

    @ApiModelProperty(value = "发布人姓名")
    
    private String releaseByName;

    @ApiModelProperty(value = "企业_ID")
    
    private Long companyId;

    @ApiModelProperty(value = "部门_ID")
    
    private Long orgId;

    @ApiModelProperty(value = "站点_ID")
    
    private Long siteId;

    /**
     * 该调研可参加人数
     */
    @ApiModelProperty(value = "可参加人数")
    
    private Integer count;

    /**
     * 实际参加人数
     */
    @ApiModelProperty(value = "实际参加人数")
    
    private Integer realCount;

    /**
     * 提醒集合，不持久化
     */
    @ApiModelProperty(value = "消息提醒")
    
    private List<TrResearchRemindVo> reminds;

    /**
     * 关联人员集合
     */
    @ApiModelProperty(value = "关联人员")
    
    private List<TrResearchAuthorizeVo> authorizes;

    @ApiModelProperty(value = "关联人员id")
    
    private List<Long> relationIds;






    /**
     * 问题集合，不持久化
     */
    @ApiModelProperty(value = "消息提醒")
    
    private List<TrResearchQuestionVo> questions;

    @ApiModelProperty(value = "改调研的答卷")
    
    private List<TrResearchAnswerVo> trResearchAnswerVos;

    @ApiModelProperty(value = "搜索列表显示状态：0未开始，1已完成，2进行中，3已过期，4未参加调研, 5已过期未调研")
    
    private Integer finishState;

    @ApiModelProperty(value = "完成时间")
    
    private Date finishTime;

    @ApiModelProperty(value = "提醒vo")
    private RemindVo remindVo;

    @ApiModelProperty(value = "各个业务设置提醒时的数据")
    
    private MessageRemindVo messageRemindVo;

    @ApiModelProperty(value = "关键字,逗号分隔")
    
    private String keywords;

    @ApiModelProperty(value = "是否启用在日历任务中显示")
    
    private Integer enableTask;

    @ApiModelProperty(value = "调研logo")
    private String image;
    
    @ApiModelProperty(value = "调研logo")
    private String logoImg;
    
    @ApiModelProperty(value = "业务类型：1调研；2投票")
    private Integer bizType;
    
    @ApiModelProperty(value = "呈现样式：1逐题呈现；2整页呈现；3整页投票单选")
    private Integer pageMode;
    
    @ApiModelProperty(value = "投票选择次数：0无限制")
    private Integer voteNum;

    @ApiModelProperty(value = "展示样式")
    private Integer styleType;

    @ApiModelProperty(value = "logoSrc")
    private String logoSrc;

}
