package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@Api(tags = "StatisticsResearchVo", description = "")
@TableName("statistics_research")
public class StatisticsResearchVo {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    
    private Long id;

    @ApiModelProperty(value = "调研ID")
    
    private Long researchId;

    @ApiModelProperty(value = "调研编码")
    
    private String researchNo;

    @ApiModelProperty(value = "调研名称")
    
    private String researchName;

    @ApiModelProperty(value = "调研开始时间")
    
    private Date researchStartTime;

    @ApiModelProperty(value = "调研结束时间")
    
    private Date researchEndTime;

    @ApiModelProperty(value = "创建调研的企业ID")
    
    private Long researchCompanyId;

    @ApiModelProperty(value = "创建调研的站点ID")
    
    private Long researchSiteId;

    @ApiModelProperty(value = "创建调研的组织ID")
    
    private Long researchOrgId;

    @ApiModelProperty(value = "调研创建时间")
    
    private Date researchCreateTime;

    @ApiModelProperty(value = "用户ID")
    
    private Long accountId;

    @ApiModelProperty(value = "用户名")
    
    private String accountName;

    @ApiModelProperty(value = "用户姓名")
    
    private String accountFullName;

    @ApiModelProperty(value = "用户状态")
    
    private Integer accountState;

    @ApiModelProperty(value = "工号")
    
    private String accountWorkNum;
    
    @ApiModelProperty(value = "学员企业ID")
    
    private Long accountCompanyId;

    @ApiModelProperty(value = "学员企业ID")
    
    private Long accountSiteId;

    @ApiModelProperty(value = "学员组织ID")
    
    private Long accountOrgId;

    @ApiModelProperty(value = "所在部门")
    
    private String orgName;

    @ApiModelProperty(value = "部门所有父节点名称")
    
    private String orgParentNames;

    @ApiModelProperty(value = "应参加状态，1应参加 0不应参加（用于统计：应参加人数，MAX取值）")
    
    private Integer canState;

    @ApiModelProperty(value = "应参加人数")
    
    private Integer canStateCount;

    @ApiModelProperty(value = "实际参加状态，1参加 0未参加（用于统计：实参加人数，MAX取值）")
    
    private Integer joinState;

    @ApiModelProperty(value = "实际参加人数")
    
    private Integer joinStateCount;

    @ApiModelProperty(value = "调研完成时间")
    
    private Date finishTime;

    @ApiModelProperty(value = "调研序号")
    
    private Integer index;

}
