package com.yizhi.research.application.vo.domain;

import java.io.Serializable;

import java.util.Date;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 答案选项
 * </p>
 *
 * @author shengchenglong123
 * @since 2018-03-19
 */
@Data
@Api(tags = "TrResearchQuestionResult", description = "答案选项")
@TableName("tr_research_answer_question_result")
public class TrResearchAnswerQuestionResultVo extends Model<TrResearchAnswerQuestionResultVo> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "答案ID，主键")
    
	private Long id;

    @ApiModelProperty(value = "冗余调研id")
	
	private Long researchId;

	@ApiModelProperty(value = "冗余answerId")
	
	private Long answerId;

    @ApiModelProperty(value = "答案题目_ID，外键")
	
	private Long answerQuestionId;

    @ApiModelProperty(value = "问题类型，1单选题、2多选题、3问答题、4打分题")
	
	private Integer questionType;

    @ApiModelProperty(value = "单选题和多选题，存放问题选中选项的ID")
	
	private Long optionId;

    @ApiModelProperty(value = "问答题，存放回答内容（question_type=3）")
	
	private String content;

    @ApiModelProperty(value = "打分题，学员给的分值")
	
	private Integer score;

    @ApiModelProperty(value = "创建时间")
	
	private Date createTime;

    @ApiModelProperty(value = "创建人ID")
	
	private Long createById;

    @ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

    @ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
