package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 答案题目
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "TrResearchAnswerQuestionVo", description = "答案题目")
@TableName("tr_research_answer_question")
public class TrResearchAnswerQuestionVo extends Model<TrResearchAnswerQuestionVo> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "答卷题目ID，主键")
    
    private Long id;

    @ApiModelProperty(value = "冗余调研id")
    
    private Long researchId;

    @ApiModelProperty(value = "答卷_ID，外键")
    
    private Long answerId;

    @ApiModelProperty(value = "问题_ID，外键")
    
    private Long questionId;

    @ApiModelProperty(value = "学员_ID")
    
    private Long accountId;

    @ApiModelProperty(value = "创建时间")
    
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    
    private String updateByName;

    @ApiModelProperty(value = "问题答案集合，不持久化")
    
    private List<TrResearchAnswerQuestionResultVo> questionResults;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
