package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 答卷
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "TrResearchAnswerVo", description = "答卷")
@TableName("tr_research_answer")
public class TrResearchAnswerVo extends Model<TrResearchAnswerVo> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "答卷ID，主键")
    
    private Long id;

    @ApiModelProperty(value = "调研主键_ID，外键")
    
    private Long researchId;

    @ApiModelProperty(value = "调研名称")
    
    private String name;

    @ApiModelProperty(value = "学员_ID")
    
    private Long accountId;

    @ApiModelProperty(value = "开始时间，用户进入考试的时间")
    
    private Date startTime;

    @ApiModelProperty(value = "提交时间")
    
    private Date submitTime;

    @ApiModelProperty(value = "调研用时，分钟")
    
    private Integer duration;

    @ApiModelProperty(value = "调研终端类型，1微信 2PC 3APP")
    
    private Integer terminalType;

    @ApiModelProperty(value = "创建时间")
    
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    
    private String updateByName;

    @ApiModelProperty(value = "企业_ID")
    
    private Long companyId;

    @ApiModelProperty(value = "部门_ID")
    
    private Long orgId;

    @ApiModelProperty(value = "站点_ID")
    
    private Long siteId;
    
    @ApiModelProperty(value = "是否完成 1：已完成(默认) 0：未完成  2：已删除")
    
    private Integer finish;

    @ApiModelProperty(value = "该调研答卷下关联的问题，不持久化")
    
    private List<TrResearchAnswerQuestionVo> answerQuestions;




    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
