package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.yizhi.research.application.vo.manage.OtherOptionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 问题
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "TrResearchQuestionVo", description = "问题")
@TableName("tr_research_question")
public class TrResearchQuestionVo extends Model<TrResearchQuestionVo> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "问题主键ID，主键")
    
    private Long id;

    @ApiModelProperty(value = "调研主键_ID，外键")
    
    private Long researchId;

    @ApiModelProperty(value = "问题类型，1单选题、2多选题、3问答题、4打分题")
    
    private Integer type;

    @ApiModelProperty(value = "问题内容")
    
    private String content;

    @ApiModelProperty(value = "选项内容")
    private String optionContent;

    @ApiModelProperty(value = "是否是重新进入 1是")
    
    private Integer isFrist =0;

    @ApiModelProperty(value = "是否是最后一题 1是")
    
    private Integer isLast =0;

    @ApiModelProperty(value = "调研说明，只有第一题有")
    
    private String remark;

    @ApiModelProperty(value = "存放附件路径，附件格式：音频、视频、图片")
    
    private String contentAppendixUrl;

    @ApiModelProperty(value = "是否必答，0非必答 1必答，默认0")
    
    private Integer needAnswer;

    @ApiModelProperty(value = "多选题：最多选择几项，0不选中 >0选中，默认0")
    
    private Integer maxSelectItem;

    @ApiModelProperty(value = "多选题：最少选择几项，0不选中 >0选中，默认0")
    
    private Integer minSelectItem;

    @ApiModelProperty(value = "最低分值（打分题有效），只对打分题有效")
    
    private Integer minScore;

    @ApiModelProperty(value = "最高分值（打分题有效），只对打分题有效")
    
    private Integer maxScore;

    @ApiModelProperty(value = "题号，不能为空")
    
    private Integer no;

    @ApiModelProperty(value = "是否跳题（单选题需要），0不支持 1支持，默认0(需求改变，这个字段无意义)")
    
    private Integer jumpable;

    @ApiModelProperty(value = "问题跳题的类型，1表示根据选项跳题，2表示指定跳题")
    
    private Integer jumpType;

    @ApiModelProperty(value = "跳转的题目题号，指定跳题时才有效")
    
    private Integer jumpNum;

    @ApiModelProperty(value = "指定跳题时才有效，越过的题号")
    
    private Integer[] jumpedNums;

    @ApiModelProperty(value = "上一题的题号")
    
    private Integer lastNo;

    @ApiModelProperty(value = "是否删除（0：未删，1：已删）")
    
    private Integer deleted;

    @ApiModelProperty(value = "创建时间")
    
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    
    private String updateByName;

    @ApiModelProperty(value = "企业_ID")
    
    private Long companyId;

    @ApiModelProperty(value = "部门_ID")
    
    private Long orgId;

    @ApiModelProperty(value = "站点_ID")
    
    private Long siteId;

    /**
     * 选择题，打分题 选项，不持久化
     */
    
    private List<TrResearchQuestionOptionVo> options;
    @ApiModelProperty("是否有题目的跳题是该题目 0没有 1有")
    
    private Integer has;

    
    private OtherOptionVo otherOptionVo;
    
    private Integer hasOther = 0;

    @ApiModelProperty(value = "其他选项input框是否必填")
    
    private Integer required = 0;

    @ApiModelProperty(value = "调研名称")
    
    private String researchName;

    @ApiModelProperty(value = "调研开始时间")
    
    private String startTime;

    @ApiModelProperty(value = "调研结束时间")
    
    private String endTime;

    @ApiModelProperty(value = "调研说明")
    
    private String researchContent; 
    
    @ApiModelProperty(value = "关键字")
    private String keywords;

    @ApiModelProperty(value = "所有题型有效：存放附件路径，附件格式：音频、视频、图片(存放多个)")
    private List<String> attachmentUrl;

    @ApiModelProperty(value = "展示样式")
    private Integer styleType;

    @ApiModelProperty(value = "展示样式")
    private String logoSrc;
    
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
