package com.yizhi.research.application.vo.manage;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/14 09:51
 */
@Data
@Api(tags = "QuestionVo", description = "调研问题vo，包括所有题型")
public class QuestionVo {

    @ApiModelProperty(value = "问题id，若是修改，必传；新增的问题，不能传值")
    private Long id;

    // *************************问题通用属性 开始**********************************

    @ApiModelProperty(value = "所属调研id", required = true)
    private Long reseachId;

    @ApiModelProperty(value = "问题类型，1单选题、2多选题、3问答题、打分题", required = true)
    private Integer type;

    @ApiModelProperty(value = "所有题型有效：题号，不能为空", required = true)
    private Integer no;

    @ApiModelProperty(value = "所有题型有效：问题内容")
    private String content;

    @ApiModelProperty(value = "所有题型有效：存放附件路径，附件格式：音频、视频、图片")
    private String contentAppendixUrl;

    @ApiModelProperty(value = "所有题型有效：是否必答，0非必答 1必答，默认0")
    private Integer needAnswer;
    // **************************问题通用属性 结束************************************


    // **************************选择题属性 开始************************************

    @ApiModelProperty(value = "多选题有效：最多选择几项，0不选中 >0选中，默认0")
    private Integer maxSelectItem;

    @ApiModelProperty(value = "多选题有效：最少选择几项，0不选中 >0选中，默认0")
    private Integer minSelectItem;

    // 单选题属性
    @ApiModelProperty(value = "单选题有效：是否跳题，0不支持 1支持，默认0")
    private Integer jumpable;
    // **************************选择题属性 结束************************************


    // **************************打分题属性 开始************************************

    @ApiModelProperty(value = "打分题有效：最高分值")
    private Integer maxScore;

    @ApiModelProperty(value = "打分题有效：最低分值")
    private Integer minScore;
    // **************************打分题属性 结束************************************

    @ApiModelProperty(value = "选择题和打分题有效：问题选项")
    private List<QuestionOptionVo> questionOptions = new ArrayList<>();

    @ApiModelProperty(value = "问题跳题的类型，1表示根据选项跳题，2表示指定跳题")
    private Integer jumpType;

    @ApiModelProperty(value = "跳转的题目题号，指定跳题时才有效")
    private Integer jumpNum;

    @ApiModelProperty(value = "其他选项，单独拿出来")
    private OtherOptionVo otherOption;

    @ApiModelProperty(value = "是否有其他")
    private Integer hasOther;

    @ApiModelProperty(value = "关键字")
    private String keywords;

    @ApiModelProperty(value = "logSrc")
    private String logoSrc;
    
    @ApiModelProperty(value = "所有题型有效：存放附件路径，附件格式：音频、视频、图片(存放多个)")
    private List<String> attachmentUrl;
}
